/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.cache;

import cirrus.hibernate.cache.Cache;
import java.util.HashMap;

public class HashBelt
implements Cache {
    private static final int LENGTH = 10;
    private long lastTime;
    private int timeout = 60000;
    private HashMap[] batches = new HashMap[10];

    public HashBelt() {
        int i = 0;
        while (i < 10) {
            this.batches[i] = new HashMap();
            ++i;
        }
        this.lastTime = System.currentTimeMillis();
    }

    public Object get(Object key) {
        this.expire();
        int i = 0;
        while (i < 10) {
            Object result = this.batches[i].get(key);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public Object invalidate(Object key) {
        this.expire();
        int i = 0;
        while (i < 10) {
            Object result = this.batches[i].remove(key);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public void put(Object key, Object value) {
        this.invalidate(key);
        this.batches[0].put(key, value);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        this.lastTime = System.currentTimeMillis();
    }

    public void setClass(String clazz) {
    }

    private void expire() {
        if (this.timeout > 0) {
            long time = System.currentTimeMillis();
            int shift = 10 * (int)(time - this.lastTime) / this.timeout;
            this.lastTime = time;
            while (shift > 0) {
                int last = 9;
                HashMap expired = this.batches[last];
                expired.clear();
                int i = last;
                while (i > 0) {
                    this.batches[i] = this.batches[i - 1];
                    --i;
                }
                this.batches[0] = expired;
                --shift;
            }
        }
    }
}

