/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.ajax4jsf.framework.util.image.ImageFilterOp;
import org.ajax4jsf.framework.util.image.ImageWaiter;
import org.ajax4jsf.framework.util.image.ImageWrapper;
import org.ajax4jsf.framework.util.message.Messages;

public abstract class ImageGenerator {
    protected static ImageGenerator generator = null;

    public static ImageGenerator getInstance() {
        if (generator == null) {
            String className = null;
            Class<?> generatorClass = null;
            if (className == null) {
                try {
                    Class.forName("com.sun.jimi.core.Jimi");
                    className = "helma.image.jimi.JimiGenerator";
                }
                catch (ClassNotFoundException e1) {
                    try {
                        Class.forName("javax.imageio.ImageIO");
                        className = "org.ajax4jsf.framework.util.image.imageio.ImageIOGenerator";
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            try {
                generatorClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(Messages.getMessage("IMAGE_GENERATOR_CLASS_NOT_FOUND", className));
            }
            try {
                generator = (ImageGenerator)generatorClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.getMessage("CREATING_IMAGE_GENERATOR_ERROR", className));
            }
        }
        return generator;
    }

    public ImageWrapper createImage(int w, int h) {
        BufferedImage img = new BufferedImage(w, h, 2);
        return new ImageWrapper(img, w, h, this);
    }

    public ImageWrapper createImage(byte[] src) throws IOException {
        Image img = this.read(src);
        return img != null ? new ImageWrapper(img, this) : null;
    }

    public ImageWrapper createImage(String filenamne) throws IOException {
        Image img = this.read(filenamne);
        return img != null ? new ImageWrapper(img, this) : null;
    }

    public ImageWrapper createImage(URL url) throws MalformedURLException, IOException {
        Image img = this.read(url);
        return img != null ? new ImageWrapper(img, this) : null;
    }

    public ImageWrapper createImage(ImageWrapper iw, ImageFilter filter) {
        return this.createImage(iw, new ImageFilterOp(filter));
    }

    public ImageWrapper createImage(ImageWrapper iw, BufferedImageOp imageOp) {
        BufferedImage img = imageOp.filter(iw.getBufferedImage(), null);
        return img != null ? new ImageWrapper(img, this) : null;
    }

    public Image read(String filename) throws IOException {
        return ImageWaiter.waitForImage(Toolkit.getDefaultToolkit().createImage(filename));
    }

    public Image read(URL url) throws IOException {
        return ImageWaiter.waitForImage(Toolkit.getDefaultToolkit().createImage(url));
    }

    public Image read(byte[] src) throws IOException {
        return ImageWaiter.waitForImage(Toolkit.getDefaultToolkit().createImage(src));
    }

    public abstract void write(ImageWrapper var1, String var2, float var3, boolean var4) throws IOException;
}

