/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax.xmlfilter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.ajax4jsf.framework.ajax.xmlfilter.HtmlParser;
import org.ajax4jsf.framework.util.message.Messages;
import org.ajax4jsf.io.FastBufferInputStream;
import org.ajax4jsf.io.FastBufferOutputStream;
import org.ajax4jsf.io.FastBufferReader;
import org.ajax4jsf.io.FastBufferWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class FilterServletResponseWrapper
extends HttpServletResponseWrapper {
    private static final Log log = LogFactory.getLog((Class)FilterServletResponseWrapper.class);
    public static final String DEFAULT_ENCODING = "UTF-8";
    protected FastBufferOutputStream byteStream = null;
    private ServletOutputStream servletOutputStream;
    private boolean useStream = false;
    private FastBufferWriter stringWriter;
    private PrintWriter printWriter;
    private boolean useWriter = false;
    private String contentType;
    private String charterEncoding = null;
    private HashMap headers = new HashMap();
    private int bufferSize = 2048;
    private int contentLength = Integer.MIN_VALUE;
    private String redirectLocation = null;
    private boolean useNullStream = false;
    private List cookies = new ArrayList();

    public FilterServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public InputStream getContentAsStream() {
        int length = 0;
        FastBufferInputStream result = null;
        String encoding = this.getCharacterEncoding();
        if (this.isUseStream()) {
            try {
                this.servletOutputStream.flush();
            }
            catch (IOException ex) {
                log.warn((Object)Messages.getMessage("FLUSH_BUFFERED_STREAM_ERROR"), (Throwable)ex);
            }
            result = new FastBufferInputStream(this.byteStream);
        } else if (this.isUseWriter()) {
            this.printWriter.flush();
            this.printWriter.close();
            length = this.stringWriter.getLength();
            try {
                FastBufferOutputStream stream = this.stringWriter.convertToOutputStream(encoding);
                result = new FastBufferInputStream(stream);
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)Messages.getMessage("UNSUPPORTED_ENCODING_WARNING"));
                FastBufferOutputStream stream = this.stringWriter.convertToOutputStream();
                result = new FastBufferInputStream(stream);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("NO_WRITER_CALLED_INFO"));
            }
            return null;
        }
        if (length > 0 && log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("PARSE_XML_DOCUMENT_INFO"));
        }
        return result;
    }

    public Reader getContentAsReader() {
        FastBufferReader result = null;
        String encoding = this.getCharacterEncoding();
        if (this.isUseWriter()) {
            this.printWriter.flush();
            this.printWriter.close();
            result = new FastBufferReader(this.stringWriter);
        } else if (this.isUseStream()) {
            try {
                this.servletOutputStream.flush();
            }
            catch (IOException ex) {
                log.warn((Object)Messages.getMessage("FLUSH_BUFFERED_STREAM_ERROR"), (Throwable)ex);
            }
            try {
                FastBufferWriter writer = this.byteStream.convertToWriter(encoding);
                result = new FastBufferReader(writer);
            }
            catch (UnsupportedEncodingException e) {
                log.warn((Object)Messages.getMessage("UNSUPPORTED_ENCODING_WARNING_2"), (Throwable)e);
                FastBufferWriter writer = this.byteStream.convertToWriter();
                result = new FastBufferReader(writer);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("NO_WRITER_CALLED_INFO"));
            }
            return null;
        }
        return result;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.useStream) {
            throw new IllegalStateException(Messages.getMessage("NO_WRITER_POSSIBLE_ERROR"));
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(new ServletStringWriter());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("CREATE_WRITER_INFO"));
        }
        this.useWriter = true;
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.useWriter) {
            if (this.isUseNullStream()) {
                return new NullServletOutputStream();
            }
            throw new IllegalStateException(Messages.getMessage("NO_STREAM_POSSIBLE_ERROR"));
        }
        if (this.servletOutputStream == null) {
            this.servletOutputStream = new ByteArrayServletOutputStream();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("CREATE_STREAM_INFO"));
        }
        this.useStream = true;
        return this.servletOutputStream;
    }

    public static String getContentTypeCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        int semicolumnIndex = contentType.indexOf(";");
        if (semicolumnIndex == -1) {
            return null;
        }
        int charsetIndex = contentType.indexOf("charset=", semicolumnIndex);
        if (charsetIndex == -1) {
            return null;
        }
        String afterCharset = contentType.substring(charsetIndex + 8);
        afterCharset = afterCharset.replace('\"', ' ');
        return afterCharset.trim();
    }

    public void addHeader(String name, String value) {
        if ("Content-Type".equals(name)) {
            this.setContentType(value);
        } else {
            this.headers.put(name, value);
            super.addHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if ("Content-Type".equals(name)) {
            this.setContentType(value);
        } else {
            this.headers.put(name, value);
            super.setHeader(name, value);
        }
    }

    public Map getHeaders() {
        return this.headers;
    }

    public String getCharacterEncoding() {
        if (null != this.charterEncoding) {
            return this.charterEncoding;
        }
        return super.getCharacterEncoding();
    }

    public void setCharacterEncoding(String charset) {
        this.charterEncoding = charset;
    }

    public void setContentType(String type) {
        String contentTypeCharset = FilterServletResponseWrapper.getContentTypeCharset(type);
        if (null != contentTypeCharset) {
            this.charterEncoding = contentTypeCharset;
        }
        this.contentType = type;
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void sendContent(ServletOutputStream outputStream) throws IOException {
        if (this.getContentLength() > 0) {
            super.setContentLength(this.getContentLength());
        }
        if (this.isUseWriter()) {
            this.printWriter.flush();
            this.printWriter.close();
            this.stringWriter.printTo(outputStream);
        } else if (this.isUseStream()) {
            try {
                this.servletOutputStream.flush();
            }
            catch (IOException ex) {
                log.warn((Object)Messages.getMessage("FLUSH_BUFFERED_STREAM_ERROR"), (Throwable)ex);
            }
            this.byteStream.writeTo((OutputStream)outputStream);
        }
    }

    public void sendContent(Writer output) throws IOException {
        if (this.getContentLength() > 0) {
            super.setContentLength(this.getContentLength());
        }
        if (this.isUseWriter()) {
            this.printWriter.flush();
            this.printWriter.close();
            this.stringWriter.writeTo(output);
        } else if (this.isUseStream()) {
            try {
                this.servletOutputStream.flush();
            }
            catch (IOException ex) {
                log.warn((Object)Messages.getMessage("FLUSH_BUFFERED_STREAM_ERROR"), (Throwable)ex);
            }
            this.byteStream.writeTo(output, this.getCharacterEncoding());
        }
    }

    public boolean isUseStream() {
        return this.useStream;
    }

    public boolean isUseWriter() {
        return this.useWriter;
    }

    public InputSource getContentAsInputSource() throws RuntimeException {
        InputSource inputSource = null;
        String encoding = this.getCharacterEncoding();
        if (this.isUseWriter()) {
            inputSource = new InputSource(this.getContentAsReader());
        } else if (this.isUseStream()) {
            inputSource = new InputSource(this.getContentAsStream());
            if (encoding != null) {
                inputSource.setEncoding(encoding);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("NO_WRITER_CALLED_INFO"));
            }
            return null;
        }
        return inputSource;
    }

    public void flushBuffer() throws IOException {
        if (this.isUseStream()) {
            this.servletOutputStream.flush();
        } else if (this.isUseWriter()) {
            this.printWriter.flush();
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void resetBuffer() {
        this.printWriter = null;
        this.stringWriter = null;
        this.servletOutputStream = null;
        this.byteStream = null;
        this.useStream = false;
        this.useWriter = false;
    }

    public void setBufferSize(int arg0) {
        this.bufferSize = arg0;
    }

    public void reset() {
        this.resetBuffer();
        this.headers = new HashMap();
        this.contentType = null;
        this.charterEncoding = null;
        super.reset();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void parseContent(Writer out, HtmlParser parser) throws IOException {
        parser.setInputEncoding(this.getCharacterEncoding());
        if (this.isUseWriter()) {
            parser.parseHtml(this.getContentAsReader(), out);
        } else if (this.isUseStream()) {
            parser.parseHtml(this.getContentAsStream(), out);
        }
    }

    public void sendRedirect(String arg0) throws IOException {
        this.redirectLocation = arg0;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public boolean isUseNullStream() {
        return this.useNullStream;
    }

    public void setUseNullStream(boolean useNullStream) {
        this.useNullStream = useNullStream;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
        super.addCookie(cookie);
    }

    public Collection getCookies() {
        return this.cookies;
    }

    public class ServletStringWriter
    extends Writer {
        private boolean opened = true;

        public ServletStringWriter() {
            FilterServletResponseWrapper.this.stringWriter = new FastBufferWriter(FilterServletResponseWrapper.this.bufferSize);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.opened) {
                FilterServletResponseWrapper.this.stringWriter.write(cbuf, off, len);
            }
        }

        public void write(char[] cbuf) throws IOException {
            if (this.opened) {
                FilterServletResponseWrapper.this.stringWriter.write(cbuf);
            }
        }

        public void write(int c) throws IOException {
            if (this.opened) {
                FilterServletResponseWrapper.this.stringWriter.write(c);
            }
        }

        public void flush() throws IOException {
            FilterServletResponseWrapper.this.stringWriter.flush();
        }

        public void close() throws IOException {
            FilterServletResponseWrapper.this.stringWriter.close();
            this.opened = false;
        }
    }

    public static class NullServletOutputStream
    extends ServletOutputStream {
        public void write(byte[] b, int off, int len) throws IOException {
        }

        public void write(byte[] b) throws IOException {
        }

        public void write(int b) throws IOException {
        }
    }

    public class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private boolean opened = true;

        public void close() throws IOException {
            this.flush();
            this.opened = false;
        }

        public void write(byte[] b) throws IOException {
            if (this.opened) {
                FilterServletResponseWrapper.this.byteStream.write(b);
            }
        }

        public ByteArrayServletOutputStream() {
            FilterServletResponseWrapper.this.byteStream = new FastBufferOutputStream(FilterServletResponseWrapper.this.bufferSize);
        }

        public void write(int b) throws IOException {
            if (this.opened) {
                FilterServletResponseWrapper.this.byteStream.write(b);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.opened) {
                FilterServletResponseWrapper.this.byteStream.write(b, off, len);
            }
        }
    }
}

