/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.ProcessClassLoader;

public class ClassLoaderUtil {
    public static Class loadClass(String className) {
        try {
            return ClassLoaderUtil.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new JbpmException("class not found '" + className + "'", e);
        }
    }

    public static ClassLoader getClassLoader() {
        return ClassLoaderUtil.class.getClassLoader();
    }

    public static InputStream getStream(String resource) {
        return ClassLoaderUtil.getClassLoader().getResourceAsStream(resource);
    }

    public static Properties getProperties(String resource) {
        Properties properties = new Properties();
        try {
            properties.load(ClassLoaderUtil.getStream(resource));
        }
        catch (IOException e) {
            throw new JbpmException("couldn't load properties file '" + resource + "'", e);
        }
        return properties;
    }

    public static ClassLoader getProcessClassLoader(ProcessDefinition processDefinition) {
        return new ProcessClassLoader(ClassLoaderUtil.class.getClassLoader(), processDefinition);
    }
}

