/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteRunner;
import org.testng.TestNGCommandLineArgs;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.internal.HostFile;
import org.testng.internal.Invoker;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationConfiguration;
import org.testng.internal.remote.SlavePool;
import org.testng.internal.thread.IPooledExecutor;
import org.testng.internal.thread.ThreadUtil;
import org.testng.remote.ConnectionInfo;
import org.testng.remote.RemoteSuiteWorker;
import org.testng.remote.RemoteTestWorker;
import org.testng.remote.RemoteWorker;
import org.testng.reporters.TestNGHTMLReporter;
import org.testng.xml.ClassSuite;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNG {
    public static final String DEFAULT_OUTPUTDIR = "test-output";
    public static final String SRC_SEPARATOR = ";";
    private static TestNG m_instance;
    private static boolean m_isJdk14;
    protected List<XmlSuite> m_suites = new ArrayList<XmlSuite>();
    protected ClassSuite m_cmdlineSuite;
    protected String m_outputDir = "test-output";
    protected String[] m_sourceDirs;
    protected String m_target;
    protected String[] m_groups;
    private Boolean m_isJUnit = Boolean.FALSE;
    private boolean m_reportResults = true;
    protected ITestRunnerFactory m_testRunnerFactory;
    protected List<ITestListener> m_testListeners = new ArrayList<ITestListener>();
    protected List<ISuiteListener> m_suiteListeners = new ArrayList<ISuiteListener>();
    public static final int HAS_FAILURE = 1;
    public static final int HAS_SKIPPED = 2;
    public static final int HAS_FSP = 4;
    protected int m_status;
    private int m_clientPort = 0;
    private String m_hostFile;
    private SlavePool m_slavePool = new SlavePool();
    private Integer m_verbose = null;

    public TestNG() {
        m_instance = this;
        TestNG.setTestNGVersion();
        this.m_target = m_isJdk14 ? "javadoc" : "1.5";
    }

    public static TestNG getDefault() {
        return m_instance;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setOutputDirectory(String outputdir) {
        if (null != outputdir && !"".equals(outputdir)) {
            this.m_outputDir = outputdir;
        }
    }

    public void setReportResults(boolean reportResults) {
        this.m_reportResults = reportResults;
    }

    public void setTarget(String target) {
        if (null == target) {
            return;
        }
        this.m_target = "1.4".equals(target) ? "javadoc" : target;
    }

    public void setSourcePath(String sourcePath) {
        if (null == sourcePath || "".equals(sourcePath.trim())) {
            return;
        }
        this.m_sourceDirs = Utils.split(sourcePath, SRC_SEPARATOR);
        AnnotationConfiguration.getInstance().getAnnotationFinder().addSourceDirs(this.m_sourceDirs);
    }

    public void setTestJar(String jarPath) {
        if (null == jarPath || "".equals(jarPath)) {
            return;
        }
        File jarFile = new File(jarPath);
        try {
            URL jarfile = new URL("jar", "", "file:" + jarFile.getAbsolutePath() + "!/");
            URLClassLoader jarLoader = new URLClassLoader(new URL[]{jarfile});
            Thread.currentThread().setContextClassLoader(jarLoader);
            this.m_suites.add(new Parser().parse());
        }
        catch (MalformedURLException mfurle) {
            System.err.println("could not find jar file named: " + jarFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            System.out.println("An exception occured while trying to load testng.xml from within jar " + jarFile.getAbsolutePath());
        }
        catch (SAXException saxe) {
            System.out.println("testng.xml from within jar " + jarFile.getAbsolutePath() + " is not well formatted");
            saxe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
    }

    public void setThreadCount(int threadCount) {
        this.m_cmdlineSuite.setThreadCount(threadCount);
    }

    public void setParallel(boolean parallel) {
        this.m_cmdlineSuite.setParallel(parallel);
    }

    public void setCommandLineSuite(ClassSuite suite) {
        this.m_cmdlineSuite = suite;
        this.m_suites.add(this.m_cmdlineSuite);
    }

    public void setTestClasses(Class[] classes) {
        this.m_cmdlineSuite = new ClassSuite("Command line test", Utils.classesToXmlClasses(classes));
        this.m_suites.add(this.m_cmdlineSuite);
    }

    public void setTestSuites(List<String> suiteXmls) {
        for (String suiteXmlPath : suiteXmls) {
            try {
                XmlSuite s = new Parser(suiteXmlPath).parse();
                this.m_suites.add(s);
            }
            catch (FileNotFoundException fne) {
                System.err.println("File not found: " + suiteXmlPath + " Ignoring.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    public void setXmlSuites(List<XmlSuite> suites) {
        this.m_suites = suites;
    }

    public void setExcludedGroups(String groups) {
        this.m_groups = Utils.split(groups, ",");
        if (null != this.m_cmdlineSuite) {
            this.m_cmdlineSuite.getTests().get(0).setExcludedGroups(Arrays.asList(this.m_groups));
        }
    }

    public void setGroups(String groups) {
        this.m_groups = Utils.split(groups, ",");
        if (null != this.m_cmdlineSuite) {
            this.m_cmdlineSuite.getTests().get(0).setIncludedGroups(Arrays.asList(this.m_groups));
        }
    }

    public void setTestRunnerFactoryClass(Class testRunnerFactoryClass) {
        this.setTestRunnerFactory((ITestRunnerFactory)this.newInstance(testRunnerFactoryClass));
    }

    public void setTestRunnerFactory(ITestRunnerFactory itrf) {
        this.m_testRunnerFactory = itrf;
    }

    public void setListenerClasses(List<Class> classes) {
        for (Class cls : classes) {
            this.addListener(this.newInstance(cls));
        }
    }

    public void setListeners(List<Object> itls) {
        for (Object obj : itls) {
            this.addListener(obj);
        }
    }

    public void addListener(Object listener) {
        if (!(listener instanceof ISuiteListener) && !(listener instanceof ITestListener)) {
            TestNG.exitWithError("Listener " + listener + " is neither an ITestListener nor an ISuiteListener");
        } else {
            if (listener instanceof ISuiteListener) {
                this.addListener((ISuiteListener)listener);
            }
            if (listener instanceof ITestListener) {
                this.addListener((ITestListener)listener);
            }
        }
    }

    public void addListener(ISuiteListener listener) {
        if (null != listener) {
            this.m_suiteListeners.add(listener);
        }
    }

    public void addListener(ITestListener listener) {
        if (null != listener) {
            this.m_testListeners.add(listener);
        }
    }

    public void setVerbose(int verbose) {
        this.m_verbose = new Integer(verbose);
    }

    public void run() {
        List<ISuite> suiteRunners = null;
        if (this.m_clientPort != 0) {
            this.waitForSuites();
        } else if (this.m_hostFile == null) {
            suiteRunners = this.runSuitesLocally();
            new TestNGHTMLReporter(suiteRunners, this.m_outputDir).generate();
        } else {
            suiteRunners = this.runSuitesRemotely();
            new TestNGHTMLReporter(suiteRunners, this.m_outputDir).generate();
        }
    }

    private static ConnectionInfo resetSocket(int clientPort, ConnectionInfo oldCi) throws IOException {
        ConnectionInfo result = new ConnectionInfo();
        ServerSocket serverSocket = new ServerSocket(clientPort);
        serverSocket.setReuseAddress(true);
        TestNG.log("Waiting for connections on port " + clientPort);
        Socket socket = serverSocket.accept();
        result.setSocket(socket);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void waitForSuites() {
        try {
            ci = TestNG.resetSocket(this.m_clientPort, null);
            while (true) lbl-1000:
            // 4 sources

            {
                try {
                    while (true) {
                        s = (XmlSuite)ci.getOis().readObject();
                        TestNG.log("Processing " + s.getName());
                        this.m_suites = new ArrayList<XmlSuite>();
                        this.m_suites.add(s);
                        suiteRunners = this.runSuitesLocally();
                        sr = suiteRunners.get(0);
                        TestNG.log("Done processing " + s.getName());
                        ci.getOos().writeObject(sr);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (EOFException ex) {
                    TestNG.log("Connection closed " + ex.getMessage());
                    ci = TestNG.resetSocket(this.m_clientPort, ci);
                }
                catch (SocketException ex) {
                    TestNG.log("Connection closed " + ex.getMessage());
                    ci = TestNG.resetSocket(this.m_clientPort, ci);
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        ** GOTO lbl-1000
    }

    private static void log(String string) {
        Utils.log("", 2, string);
    }

    private List<ISuite> runSuitesRemotely() {
        ArrayList<ISuite> result = new ArrayList<ISuite>();
        HostFile hostFile = new HostFile(this.m_hostFile);
        String[] hosts = hostFile.getHosts();
        Socket[] sockets = new Socket[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            String host = hosts[i];
            String[] s = host.split(":");
            try {
                sockets[i] = new Socket(s[0], Integer.parseInt(s[1]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                Utils.error("Couldn't connect to " + host + ": " + iOException.getMessage());
            }
        }
        try {
            this.m_slavePool.addSlaves(sockets);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ArrayList<RemoteWorker> workers = new ArrayList<RemoteWorker>();
        if (hostFile.isStrategyTest()) {
            for (XmlSuite suite : this.m_suites) {
                suite.setVerbose(hostFile.getVerbose());
                SuiteRunner suiteRunner = new SuiteRunner(suite, this.m_outputDir);
                for (XmlTest test : suite.getTests()) {
                    XmlSuite tmpSuite = new XmlSuite();
                    tmpSuite.setXmlPackages(suite.getXmlPackages());
                    tmpSuite.setAnnotations(suite.getAnnotations());
                    tmpSuite.setJUnit(suite.isJUnit());
                    tmpSuite.setName("Temporary suite for " + test.getName());
                    tmpSuite.setParallel(suite.isParallel());
                    tmpSuite.setParameters(suite.getParameters());
                    tmpSuite.setThreadCount(suite.getThreadCount());
                    tmpSuite.setVerbose(suite.getVerbose());
                    XmlTest tmpTest = new XmlTest(tmpSuite);
                    tmpTest.setAnnotations(test.getAnnotations());
                    tmpTest.setBeanShellExpression(test.getExpression());
                    tmpTest.setClassNames(test.getXmlClasses());
                    tmpTest.setExcludedGroups(test.getExcludedGroups());
                    tmpTest.setIncludedGroups(test.getIncludedGroups());
                    tmpTest.setJUnit(test.isJUnit());
                    tmpTest.setMethodSelectors(test.getMethodSelectors());
                    tmpTest.setName(test.getName());
                    tmpTest.setParallel(test.isParallel());
                    tmpTest.setParameters(test.getParameters());
                    tmpTest.setVerbose(test.getVerbose());
                    tmpTest.setXmlClasses(test.getXmlClasses());
                    tmpTest.setXmlPackages(test.getXmlPackages());
                    workers.add(new RemoteTestWorker(tmpSuite, this.m_slavePool, suiteRunner, result));
                }
                result.add(suiteRunner);
            }
        } else {
            for (XmlSuite suite : this.m_suites) {
                workers.add(new RemoteSuiteWorker(suite, this.m_slavePool, result));
            }
        }
        IPooledExecutor executor = ThreadUtil.createPooledExecutor(1);
        for (Runnable runnable : workers) {
            executor.execute(runnable);
        }
        executor.shutdown();
        long maxTimeOut = 10000L;
        try {
            executor.awaitTermination(maxTimeOut);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (ISuite suite : result) {
            for (ISuiteResult suiteResult : suite.getResults().values()) {
                Collection[] allTests;
                for (Collection all : allTests = new Collection[]{suiteResult.getTestContext().getPassedTests().values(), suiteResult.getTestContext().getFailedTests().values(), suiteResult.getTestContext().getSkippedTests().values(), suiteResult.getTestContext().getFailedButWithinSuccessPercentageTests().values()}) {
                    for (ITestResult tr : all) {
                        Invoker.runTestListeners(tr, this.m_testListeners);
                    }
                }
            }
        }
        return result;
    }

    public List<ISuite> runSuitesLocally() {
        ArrayList<ISuite> result = new ArrayList<ISuite>();
        if (this.m_suites.size() > 0) {
            for (XmlSuite xmlSuite : this.m_suites) {
                if (xmlSuite instanceof ClassSuite) {
                    xmlSuite.setAnnotations(this.m_target);
                }
                if (null != this.m_isJUnit) {
                    xmlSuite.setJUnit(this.m_isJUnit);
                }
                if (null != this.m_verbose) {
                    xmlSuite.setVerbose(this.m_verbose);
                }
                result.add(this.createAndRunSuiteRunners(xmlSuite));
            }
        } else {
            System.err.println("[WARNING]: No test suite found.  Nothing to run");
        }
        return result;
    }

    private SuiteRunner createAndRunSuiteRunners(XmlSuite xmlSuite) {
        SuiteRunner result = null;
        result = null != this.m_testRunnerFactory ? new SuiteRunner(xmlSuite, this.m_outputDir, this.m_testRunnerFactory, this.m_reportResults) : new SuiteRunner(xmlSuite, this.m_outputDir, this.m_reportResults);
        for (ISuiteListener isl : this.m_suiteListeners) {
            result.addListener(isl);
        }
        result.setTestListeners(this.m_testListeners);
        if (this.m_clientPort != 0) {
            try {
                result.setHost(InetAddress.getLocalHost() + ":" + this.m_clientPort);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        result.run();
        return result;
    }

    private Object newInstance(Class clazz) {
        try {
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (IllegalAccessException iae) {
            throw new TestNGException("Class " + clazz.getName() + " does not have a no-args constructor", iae);
        }
        catch (InstantiationException ie) {
            throw new TestNGException("Cannot instantiate class " + clazz.getName(), ie);
        }
        catch (ExceptionInInitializerError eiierr) {
            throw new TestNGException("An exception occured in static initialization of class " + clazz.getName(), eiierr);
        }
        catch (SecurityException se) {
            throw new TestNGException(se);
        }
    }

    public static void main(String[] argv) {
        TestNG testng = TestNG.privateMain(argv, null);
        System.exit(testng.getStatus());
    }

    public static TestNG privateMain(String[] argv, ITestListener listener) {
        Map cmdLineArgs = TestNGCommandLineArgs.parseCommandLine(argv);
        TestNG.setTestNGVersion();
        TestNG result = new TestNG();
        if (null != listener) {
            result.addListener(listener);
        }
        try {
            List listenerClasses;
            List testNgXml;
            TestNG.checkConditions(cmdLineArgs);
            Object verbose = cmdLineArgs.get("-log");
            if (null != verbose) {
                result.setVerbose((Integer)verbose);
            }
            result.setOutputDirectory((String)cmdLineArgs.get("-d"));
            result.setSourcePath((String)cmdLineArgs.get("-sourcedir"));
            List testClasses = (List)cmdLineArgs.get("-testclass");
            if (null != testClasses) {
                Class[] classes = testClasses.toArray(new Class[testClasses.size()]);
                result.setTestClasses(classes);
            }
            if (null != (testNgXml = (List)cmdLineArgs.get("testng.suite.definitions"))) {
                result.setTestSuites(testNgXml);
            }
            result.setGroups((String)cmdLineArgs.get("-groups"));
            result.setExcludedGroups((String)cmdLineArgs.get("-excludegroups"));
            result.setTarget((String)cmdLineArgs.get("-target"));
            result.setTestJar((String)cmdLineArgs.get("-testjar"));
            result.setJUnit((Boolean)cmdLineArgs.get("-junit"));
            result.setHostFile((String)cmdLineArgs.get("-hostfile"));
            String client = (String)cmdLineArgs.get("-slave");
            if (client != null) {
                result.setClientPort(Integer.parseInt(client));
            }
            if (null != (listenerClasses = (List)cmdLineArgs.get("-listener"))) {
                result.setListenerClasses(listenerClasses);
            }
            result.run();
        }
        catch (TestNGException ex) {
            if (TestRunner.getVerbose() > 1) {
                ex.printStackTrace();
            }
            System.err.println("[ERROR]: " + ex.getMessage());
        }
        return result;
    }

    private void setClientPort(int clientPort) {
        this.m_clientPort = clientPort;
    }

    public void setHostFile(String hostFile) {
        this.m_hostFile = hostFile;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public static void setTestNGVersion() {
        try {
            Class<?> cls = Class.forName("org.testng.annotations.Test");
            m_isJdk14 = false;
        }
        catch (ClassNotFoundException ex) {
            m_isJdk14 = true;
        }
    }

    public static boolean isJdk14() {
        return m_isJdk14;
    }

    public static void checkConditions(Map params) {
        String srcPath;
        List testClasses = (List)params.get("-testclass");
        List testNgXml = (List)params.get("testng.suite.definitions");
        Object port = params.get("-slave");
        if (testClasses == null && testNgXml == null && port == null) {
            System.err.println("You need to specify at least one testng.xml or one class");
            TestNG.usage();
            System.exit(-1);
        }
        if (TestNG.isJdk14() && (null == (srcPath = (String)params.get("-sourcedir")) || "".equals(srcPath))) {
            throw new TestNGException("No sourcedir was specified");
        }
        String groups = (String)params.get("-groups");
        String excludedGroups = (String)params.get("-excludegroups");
        if ((null != groups || null != excludedGroups) && null == testClasses) {
            throw new TestNGException("Groups option should be used with testclass option");
        }
    }

    private static void ppp(String s) {
        System.out.println("[TestNG] " + s);
    }

    public boolean hasFailure() {
        return (this.getStatus() & 1) == 1;
    }

    public void setHasFailure(boolean hasFailure) {
        this.m_status |= 1;
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return (this.getStatus() & 4) == 4;
    }

    public void setHasFailureWithinSuccessPercentage(boolean hasFailureWithinSuccessPercentage) {
        this.m_status |= 4;
    }

    public boolean hasSkip() {
        return (this.getStatus() & 2) == 2;
    }

    public void setHasSkip(boolean hasSkip) {
        this.m_status |= 2;
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("[-d output-directory]");
        System.out.println("\t\tdefault output directory to : test-output");
        System.out.println("[-testclass list of .class files or list of class names]");
        System.out.println("[-sourcedir ; separated list of source directories]");
        System.out.println("[-target 1.4 or 1.5]");
        System.out.println("\t\tused only with JDK1.5 to specify the annotation type used in test classes; default target: 1.5");
        System.out.println("[-groups comma-separated list of group names to be run]");
        System.out.println("\t\tworks only with -testclass");
        System.out.println("[-excludegroups comma-separated list of group names to be excluded]");
        System.out.println("\t\tworks only with -testclass");
        System.out.println("[-testrunfactory list of .class files or list of class names implementing " + ITestRunnerFactory.class.getName() + "]");
        System.out.println("[-listener list of .class files or list of class names implementing " + ITestListener.class.getName() + " and/or " + ISuiteListener.class.getName() + "]");
        System.out.println("[suite definition files*]");
        System.out.println("");
        System.out.println("For details please consult documentation.");
    }

    public static void exitWithError(String msg) {
        System.err.println(msg);
        TestNG.usage();
        System.exit(0);
    }
}

