/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteResult;
import org.testng.TestListenerAdapter;
import org.testng.TestRunner;
import org.testng.internal.IInvoker;
import org.testng.internal.TestNGMethod;
import org.testng.internal.annotations.AnnotationConfiguration;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.reporters.FailedReporter;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.StateReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.reporters.TextReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteRunner
implements ISuite,
Serializable {
    private static final long serialVersionUID = 5284208932089503131L;
    private static final String DEFAULT_OUTPUT_DIR = "test-output";
    private Map<String, ISuiteResult> m_suiteResults = new HashMap<String, ISuiteResult>();
    private List<TestRunner> m_testRunners = new ArrayList<TestRunner>();
    private transient List<ISuiteListener> m_listeners = new ArrayList<ISuiteListener>();
    private transient TestListenerAdapter m_textReporter = new TestListenerAdapter();
    private String m_outputDir = "test-output";
    private XmlSuite m_suite;
    private transient List<ITestListener> m_testlisteners = new ArrayList<ITestListener>();
    private transient ITestRunnerFactory m_tmpRunnerFactory;
    private transient ITestRunnerFactory m_runnerFactory;
    private transient boolean m_reportResults = true;
    private String m_host;

    public SuiteRunner(XmlSuite suite, String outputDir) {
        this(suite, outputDir, null, false);
    }

    public SuiteRunner(XmlSuite suite, String outputDir, boolean reportResults) {
        this(suite, outputDir, null, reportResults);
    }

    public SuiteRunner(XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory) {
        this(suite, outputDir, runnerFactory, false);
    }

    public SuiteRunner(XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean reportResults) {
        this.m_suite = suite;
        this.m_reportResults = reportResults;
        this.m_tmpRunnerFactory = runnerFactory;
        this.setOutputDir(outputDir);
    }

    @Override
    public String getName() {
        return this.m_suite.getName();
    }

    public void setTestListeners(List<ITestListener> testlisteners) {
        this.m_testlisteners = testlisteners;
    }

    public void setReportResults(boolean reportResults) {
        this.m_reportResults = reportResults;
    }

    private void invokeListeners(boolean start) {
        for (ISuiteListener sl : this.m_listeners) {
            if (start) {
                sl.onStart(this);
                continue;
            }
            sl.onFinish(this);
        }
    }

    private void setOutputDir(String outputdir) {
        if (null == outputdir || "".equals(outputdir.trim())) {
            outputdir = DEFAULT_OUTPUT_DIR;
        }
        this.m_outputDir = new File(outputdir).getAbsolutePath();
    }

    private void lazyInit() {
        this.m_runnerFactory = this.buildRunnerFactory(this.m_testlisteners);
    }

    protected ITestRunnerFactory buildRunnerFactory(List testListeners) {
        ITestRunnerFactory factory = null;
        if (null == this.m_tmpRunnerFactory) {
            factory = new DefaultTestRunnerFactory(this.m_testlisteners.toArray(new ITestListener[this.m_testlisteners.size()]), this.m_reportResults);
        } else {
            this.m_testlisteners.add(new StateReporter());
            factory = new ProxyTestRunnerFactory(this.m_testlisteners.toArray(new ITestListener[this.m_testlisteners.size()]), this.m_tmpRunnerFactory);
        }
        return factory;
    }

    @Override
    public boolean isParallel() {
        return this.m_suite.isParallel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.lazyInit();
        this.invokeListeners(true);
        try {
            this.privateRun();
            Object var2_1 = null;
            this.invokeListeners(false);
            if (this.m_suite.getVerbose() <= 0) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.invokeListeners(false);
            if (this.m_suite.getVerbose() <= 0) throw throwable;
            int total = this.m_textReporter.getAllTestMethods().length;
            List<ITestResult> skipped = this.m_textReporter.getSkippedTests();
            List<ITestResult> failed = this.m_textReporter.getFailedTests();
            System.out.println("\n===============================================\n" + this.getName() + "\n" + "Total tests run: " + total + ", Failures: " + failed.size() + ", Skips: " + skipped.size() + "\n" + "===============================================\n");
            throw throwable;
        }
        int total = this.m_textReporter.getAllTestMethods().length;
        List<ITestResult> skipped = this.m_textReporter.getSkippedTests();
        List<ITestResult> failed = this.m_textReporter.getFailedTests();
        System.out.println("\n===============================================\n" + this.getName() + "\n" + "Total tests run: " + total + ", Failures: " + failed.size() + ", Skips: " + skipped.size() + "\n" + "===============================================\n");
    }

    private void privateRun() {
        HashMap<ITestNGMethod, ITestNGMethod> beforeSuiteMethods = new HashMap<ITestNGMethod, ITestNGMethod>();
        HashMap<ITestNGMethod, ITestNGMethod> afterSuiteMethods = new HashMap<ITestNGMethod, ITestNGMethod>();
        IInvoker invoker = null;
        for (XmlTest test : this.m_suite.getTests()) {
            TestRunner tr = this.m_runnerFactory.newTestRunner(this, test);
            tr.addTestListener(this.m_textReporter);
            this.m_testRunners.add(tr);
            invoker = tr.getInvoker();
            for (ITestNGMethod m : tr.getBeforeSuiteMethods()) {
                beforeSuiteMethods.put(m, m);
            }
            for (ITestNGMethod m : tr.getAfterSuiteMethods()) {
                afterSuiteMethods.put(m, m);
            }
        }
        invoker.invokeConfigurations(null, beforeSuiteMethods.values().toArray(new ITestNGMethod[beforeSuiteMethods.size()]), this.m_suite, this.m_suite.getParameters(), null);
        for (TestRunner tr : this.m_testRunners) {
            Map parameters = tr.getTest().getParameters();
            tr.getInvoker().invokeConfigurations(null, tr.getBeforeTestConfigurationMethods(), this.m_suite, parameters, null);
            tr.run();
            tr.getInvoker().invokeConfigurations(null, tr.getAfterTestConfigurationMethods(), this.m_suite, parameters, null);
            SuiteResult sr = new SuiteResult(this.m_suite, (ITestContext)tr);
            this.m_suiteResults.put(tr.getName(), sr);
        }
        invoker.invokeConfigurations(null, afterSuiteMethods.values().toArray(new ITestNGMethod[afterSuiteMethods.size()]), this.m_suite, this.m_suite.getAllParameters(), null);
    }

    public void addListener(ISuiteListener reporter) {
        this.m_listeners.add(reporter);
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDir;
    }

    @Override
    public Map<String, ISuiteResult> getResults() {
        return this.m_suiteResults;
    }

    @Override
    public String getParameter(String parameterName) {
        return this.m_suite.getParameter(parameterName);
    }

    @Override
    public Map<String, Collection<ITestNGMethod>> getMethodsByGroups() {
        HashMap<String, Collection<ITestNGMethod>> result = new HashMap<String, Collection<ITestNGMethod>>();
        for (TestRunner tr : this.m_testRunners) {
            ITestNGMethod[] methods;
            for (ITestNGMethod m : methods = tr.getTestMethods()) {
                String[] groups;
                for (String groupName : groups = m.getGroups()) {
                    ArrayList<ITestNGMethod> testMethods = (ArrayList<ITestNGMethod>)result.get(groupName);
                    if (null == testMethods) {
                        testMethods = new ArrayList<ITestNGMethod>();
                        result.put(groupName, testMethods);
                    }
                    testMethods.add(m);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<ITestNGMethod> getInvokedMethods() {
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
        HashMap<ITestNGMethod, ITestNGMethod> seen = new HashMap<ITestNGMethod, ITestNGMethod>();
        for (TestRunner tr : this.m_testRunners) {
            List<ITestNGMethod> methods = tr.getInvokedMethods();
            for (ITestNGMethod m : methods) {
                if (seen.containsKey(m)) continue;
                seen.put(m, m);
                result.add(m);
            }
        }
        Collections.sort(result, TestNGMethod.DATE_COMPARATOR);
        return result;
    }

    protected static IAnnotationFinder getAnnotationFinder(XmlTest test) {
        AnnotationConfiguration annotConfig = AnnotationConfiguration.getInstance();
        int annotationType = "javadoc".equals(test.getAnnotations()) ? 2 : 1;
        annotConfig.initialize(annotationType);
        return annotConfig.getAnnotationFinder();
    }

    public static void ppp(String s) {
        System.out.println("[SuiteRunner] " + s);
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    public static class ProxyTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private ITestRunnerFactory m_target;

        public ProxyTestRunnerFactory(ITestListener[] failureListeners, ITestRunnerFactory target) {
            this.m_failureGenerators = failureListeners;
            this.m_target = target;
        }

        public TestRunner newTestRunner(ISuite suite, XmlTest test) {
            TestRunner testRunner = this.m_target.newTestRunner(suite, test);
            testRunner.addTestListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            for (ITestListener itl : this.m_failureGenerators) {
                testRunner.addTestListener(itl);
            }
            return testRunner;
        }
    }

    public static class DefaultTestRunnerFactory
    implements ITestRunnerFactory {
        private ITestListener[] m_failureGenerators;
        private boolean m_reportResult;

        public DefaultTestRunnerFactory(ITestListener[] failureListeners, boolean reportResult) {
            this.m_failureGenerators = failureListeners;
            this.m_reportResult = reportResult;
        }

        public TestRunner newTestRunner(ISuite suite, XmlTest test) {
            TestRunner testRunner = new TestRunner(suite, test, suite.getOutputDirectory(), SuiteRunner.getAnnotationFinder(test));
            if (this.m_reportResult) {
                testRunner.addTestListener(new TestHTMLReporter());
                testRunner.addTestListener(new JUnitXMLReporter());
                testRunner.addTestListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
                testRunner.addTestListener(new FailedReporter(test.getSuite()));
            }
            testRunner.addTestListener(new StateReporter());
            for (ITestListener itl : this.m_failureGenerators) {
                testRunner.addTestListener(itl);
            }
            return testRunner;
        }
    }
}

