/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.reflection.XClass;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.util.StringHelper;

public class OneToOneSecondPass
implements SecondPass {
    private String mappedBy;
    private ExtendedMappings mappings;
    private String ownerEntity;
    private String ownerProperty;
    private PropertyHolder propertyHolder;
    private boolean ignoreNotFound;
    private PropertyData inferredData;
    private XClass targetEntity;
    private boolean cascadeOnDelete;
    private boolean optional;
    private String cascadeStrategy;
    private Ejb3JoinColumn[] joinColumns;

    public OneToOneSecondPass(String mappedBy, String ownerEntity, String ownerProperty, PropertyHolder propertyHolder, PropertyData inferredData, XClass targetEntity, boolean ignoreNotFound, boolean cascadeOnDelete, boolean optional, String cascadeStrategy, Ejb3JoinColumn[] columns, ExtendedMappings mappings) {
        this.ownerEntity = ownerEntity;
        this.ownerProperty = ownerProperty;
        this.mappedBy = mappedBy;
        this.propertyHolder = propertyHolder;
        this.mappings = mappings;
        this.ignoreNotFound = ignoreNotFound;
        this.inferredData = inferredData;
        this.targetEntity = targetEntity;
        this.cascadeOnDelete = cascadeOnDelete;
        this.optional = optional;
        this.cascadeStrategy = cascadeStrategy;
        this.joinColumns = columns;
    }

    public void doSecondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
        OneToOne value = new OneToOne(this.propertyHolder.getTable(), this.propertyHolder.getPersistentClass());
        String propertyName = this.inferredData.getPropertyName();
        value.setPropertyName(propertyName);
        String referencedEntityName = AnnotationBinder.isDefault(this.targetEntity, this.mappings) ? this.inferredData.getClassOrElementName() : this.targetEntity.getName();
        value.setReferencedEntityName(referencedEntityName);
        AnnotationBinder.defineFetchingStrategy(value, this.inferredData.getProperty());
        value.setCascadeDeleteEnabled(this.cascadeOnDelete);
        if (!this.optional) {
            value.setConstrained(true);
        }
        value.setForeignKeyType(value.isConstrained() ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setValue(value);
        binder.setCascade(this.cascadeStrategy);
        binder.setPropertyAccessorName(this.inferredData.getDefaultAccess());
        Property prop = binder.make();
        if (AnnotationBinder.isDefault(this.mappedBy)) {
            boolean rightOrder = true;
            if (rightOrder) {
                String path = StringHelper.qualify(this.propertyHolder.getPath(), propertyName);
                new FkSecondPass(value, this.joinColumns, !this.optional, path, this.mappings).doSecondPass(persistentClasses, inheritedMetas);
                this.propertyHolder.addProperty(prop);
            }
        } else {
            Property otherSideProperty;
            PersistentClass otherSide = (PersistentClass)persistentClasses.get(value.getReferencedEntityName());
            try {
                if (otherSide == null) {
                    throw new MappingException("Unable to find entity: " + value.getReferencedEntityName());
                }
                otherSideProperty = otherSide.getProperty(this.mappedBy);
            }
            catch (MappingException e) {
                throw new AnnotationException("Unknown mappedBy in: " + StringHelper.qualify(this.ownerEntity, this.ownerProperty) + ", referenced property unknown: " + StringHelper.qualify(value.getReferencedEntityName(), this.mappedBy));
            }
            if (otherSideProperty.getValue() instanceof OneToOne) {
                this.propertyHolder.addProperty(prop);
            } else if (otherSideProperty.getValue() instanceof ManyToOne) {
                Iterator it = otherSide.getJoinIterator();
                Join otherSideJoin = null;
                while (it.hasNext() && !(otherSideJoin = (Join)it.next()).containsProperty(otherSideProperty)) {
                }
                if (otherSideJoin != null) {
                    Join mappedByJoin = this.buildJoin((PersistentClass)persistentClasses.get(this.ownerEntity), otherSideProperty, otherSideJoin);
                    ManyToOne manyToOne = new ManyToOne(mappedByJoin.getTable());
                    manyToOne.setIgnoreNotFound(this.ignoreNotFound);
                    manyToOne.setCascadeDeleteEnabled(value.isCascadeDeleteEnabled());
                    manyToOne.setEmbedded(value.isEmbedded());
                    manyToOne.setFetchMode(value.getFetchMode());
                    manyToOne.setLazy(value.isLazy());
                    manyToOne.setReferencedEntityName(value.getReferencedEntityName());
                    manyToOne.setUnwrapProxy(value.isUnwrapProxy());
                    prop.setValue(manyToOne);
                    Iterator otherSideJoinKeyColumns = otherSideJoin.getKey().getColumnIterator();
                    while (otherSideJoinKeyColumns.hasNext()) {
                        Column column = (Column)otherSideJoinKeyColumns.next();
                        Column copy = new Column();
                        copy.setLength(column.getLength());
                        copy.setScale(column.getScale());
                        copy.setValue(manyToOne);
                        copy.setName(column.getQuotedName());
                        copy.setNullable(column.isNullable());
                        copy.setPrecision(column.getPrecision());
                        copy.setUnique(column.isUnique());
                        copy.setSqlType(column.getSqlType());
                        copy.setCheckConstraint(column.getCheckConstraint());
                        copy.setComment(column.getComment());
                        copy.setDefaultValue(column.getDefaultValue());
                        manyToOne.addColumn(copy);
                    }
                    mappedByJoin.addProperty(prop);
                } else {
                    this.propertyHolder.addProperty(prop);
                }
                value.setReferencedPropertyName(this.mappedBy);
                String propertyRef = value.getReferencedPropertyName();
                if (propertyRef != null) {
                    this.mappings.addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
                }
            } else {
                throw new AnnotationException("Referenced property not a (One|Many)ToOne: " + StringHelper.qualify(value.getReferencedEntityName(), value.getReferencedPropertyName()) + " in mappedBy of " + StringHelper.qualify(this.ownerEntity, this.ownerProperty));
            }
        }
    }

    private Join buildJoin(PersistentClass persistentClass, Property otherSideProperty, Join originalJoin) {
        Join join = new Join();
        join.setPersistentClass(persistentClass);
        join.setTable(originalJoin.getTable());
        join.setInverse(true);
        DependantValue key = new DependantValue(join.getTable(), persistentClass.getIdentifier());
        join.setKey(key);
        join.setSequentialSelect(false);
        join.setOptional(true);
        key.setCascadeDeleteEnabled(false);
        Iterator mappedByColumns = otherSideProperty.getValue().getColumnIterator();
        while (mappedByColumns.hasNext()) {
            Column column = (Column)mappedByColumns.next();
            Column copy = new Column();
            copy.setLength(column.getLength());
            copy.setScale(column.getScale());
            copy.setValue(key);
            copy.setName(column.getQuotedName());
            copy.setNullable(column.isNullable());
            copy.setPrecision(column.getPrecision());
            copy.setUnique(column.isUnique());
            copy.setSqlType(column.getSqlType());
            copy.setCheckConstraint(column.getCheckConstraint());
            copy.setComment(column.getComment());
            copy.setDefaultValue(column.getDefaultValue());
            key.addColumn(copy);
        }
        join.createPrimaryKey();
        join.createForeignKey();
        persistentClass.addJoin(join);
        return join;
    }
}

