/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.jboss.util.id.SerialVersion;

public class QName
implements Serializable {
    static final long serialVersionUID = SerialVersion.version == 0 ? 8217399441836960859L : -3852060120346905000L;
    private String namespaceURI;
    private String localPart;
    private String prefix;

    public QName(String namespaceURI, String localPart) {
        this(namespaceURI, localPart, "");
    }

    public QName(String namespaceURI, String localPart, String prefix) {
        this.namespaceURI = namespaceURI;
        if (this.namespaceURI == null) {
            this.namespaceURI = "";
        }
        if (localPart == null) {
            throw new IllegalArgumentException("localPart cannot be null");
        }
        if (localPart.startsWith(":")) {
            throw new IllegalArgumentException("Illegal localPart: " + localPart);
        }
        this.localPart = localPart;
        this.prefix = prefix;
        if (this.prefix == null) {
            this.prefix = "";
        }
    }

    public QName(String localPart) {
        this(null, localPart);
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QName) {
            QName qn = (QName)obj;
            boolean equals = this.namespaceURI.equals(qn.namespaceURI);
            return equals && this.localPart.equals(qn.localPart);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.namespaceURI.hashCode() + this.localPart.hashCode();
        return hashCode;
    }

    public String toString() {
        if (this.namespaceURI.equals("")) {
            return this.localPart;
        }
        return '{' + this.namespaceURI + '}' + this.localPart;
    }

    public static QName valueOf(String toStringName) {
        String uri = null;
        String localPart = null;
        StringTokenizer tokenizer = new StringTokenizer(toStringName, "{}");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount < 1 || tokenCount > 2) {
            throw new IllegalArgumentException("Invalid QName string: " + toStringName);
        }
        if (tokenCount > 1) {
            uri = tokenizer.nextToken();
        }
        localPart = tokenizer.nextToken();
        return new QName(uri, localPart);
    }
}

