/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.stmt;

import com.mchange.v2.c3p0.stmt.MemoryCoalescedStatementCacheKey;
import com.mchange.v2.c3p0.stmt.SimpleStatementCacheKey;
import com.mchange.v2.c3p0.stmt.ValueIdentityStatementCacheKey;
import java.lang.reflect.Method;
import java.sql.Connection;

abstract class StatementCacheKey {
    static final int SIMPLE = 0;
    static final int MEMORY_COALESCED = 1;
    static final int VALUE_IDENTITY = 2;
    Connection physicalConnection;
    String stmtText;
    boolean is_callable;
    int result_set_type;
    int result_set_concurrency;

    public static StatementCacheKey find(Connection connection, Method method, Object[] objectArray) {
        switch (2) {
            case 0: {
                return SimpleStatementCacheKey._find(connection, method, objectArray);
            }
            case 1: {
                return MemoryCoalescedStatementCacheKey._find(connection, method, objectArray);
            }
            case 2: {
                return ValueIdentityStatementCacheKey._find(connection, method, objectArray);
            }
        }
        throw new InternalError("StatementCacheKey.find() is misconfigured.");
    }

    StatementCacheKey() {
    }

    StatementCacheKey(Connection connection, String string, boolean bl, int n, int n2) {
        this.init(connection, string, bl, n, n2);
    }

    void init(Connection connection, String string, boolean bl, int n, int n2) {
        this.physicalConnection = connection;
        this.stmtText = string;
        this.is_callable = bl;
        this.result_set_type = n;
        this.result_set_concurrency = n2;
    }

    static boolean equals(StatementCacheKey statementCacheKey, Object object) {
        if (statementCacheKey == object) {
            return true;
        }
        if (object instanceof StatementCacheKey) {
            StatementCacheKey statementCacheKey2 = (StatementCacheKey)object;
            return statementCacheKey2.physicalConnection.equals(statementCacheKey.physicalConnection) && statementCacheKey2.stmtText.equals(statementCacheKey.stmtText) && statementCacheKey2.is_callable == statementCacheKey.is_callable && statementCacheKey2.result_set_type == statementCacheKey.result_set_type && statementCacheKey2.result_set_concurrency == statementCacheKey.result_set_concurrency;
        }
        return false;
    }

    static int hashCode(StatementCacheKey statementCacheKey) {
        return statementCacheKey.physicalConnection.hashCode() ^ statementCacheKey.stmtText.hashCode() ^ (statementCacheKey.is_callable ? 1 : 0) ^ statementCacheKey.result_set_type ^ statementCacheKey.result_set_concurrency;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("[StatementCacheKey: ");
        stringBuffer.append("physicalConnection-> " + this.physicalConnection);
        stringBuffer.append(", stmtText->" + this.stmtText);
        stringBuffer.append(", is_callable->" + this.is_callable);
        stringBuffer.append(", result_set_type->" + this.result_set_type);
        stringBuffer.append(", result_set_concurrency->" + this.result_set_concurrency);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

