/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.aspects.asynch.AsynchMixin;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.LocalProxy;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.util.id.GUID;

public class StatefulLocalProxy
extends LocalProxy {
    protected Object id;
    AsynchProvider provider;
    protected Class[] initTypes = null;
    protected Object[] initValues = null;

    protected StatefulLocalProxy() {
    }

    public StatefulLocalProxy(Container container) {
        super(container);
    }

    public StatefulLocalProxy(Container container, Class[] initTypes, Object[] initValues) {
        super(container);
        this.initTypes = initTypes;
        this.initValues = initValues;
    }

    public StatefulLocalProxy(AsynchProvider provider, Container container, Object id) {
        super(container);
        this.provider = provider;
        this.id = id;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret;
        if (method.getDeclaringClass() == AsynchProvider.class) {
            return this.provider.getFuture();
        }
        StatefulContainer sfsb = (StatefulContainer)this.container;
        if (this.id == null) {
            this.id = this.initTypes == null ? sfsb.createSession() : sfsb.createSession(this.initTypes, this.initValues);
        }
        if ((ret = ProxyUtils.handleCallLocally((JBossProxy)proxy, this, method, args)) != null) {
            return ret;
        }
        return sfsb.localInvoke(this.id, method, args, (FutureHolder)this.provider);
    }

    public Object getAsynchronousProxy(Object proxy) {
        Class[] infs = proxy.getClass().getInterfaces();
        if (!ProxyUtils.isAsynchronous(infs)) {
            Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
            AsynchMixin mixin = new AsynchMixin();
            StatefulLocalProxy handler = new StatefulLocalProxy((AsynchProvider)mixin, this.container, this.id);
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return proxy;
    }

    public String toString() {
        if (this.id != null) {
            return this.container.getEjbName().toString() + ":" + this.id.toString();
        }
        GUID guid = new GUID();
        return this.container.getEjbName().toString() + ":" + guid.toString();
    }
}

