/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.security.RunAs;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class RunAsSecurityInterceptor
extends org.jboss.aspects.security.RunAsSecurityInterceptor {
    private static final Logger log = Logger.getLogger(RunAsSecurityInterceptor.class);

    public RunAsSecurityInterceptor(AuthenticationManager manager, RealmMapping realmMapping) {
        super(manager, realmMapping);
    }

    protected RunAsIdentity getRunAsIdentity(Invocation invocation) {
        RunAsIdentity runAsRole = null;
        RunAs runAs = (RunAs)invocation.resolveClassAnnotation(RunAs.class);
        if (runAs == null) {
            return null;
        }
        Principal principal = SecurityAssociation.getPrincipal();
        Set extraRoles = this.realmMapping.getUserRoles(principal);
        if (extraRoles != null) {
            Iterator roles = extraRoles.iterator();
            HashSet<String> extraRoleNames = new HashSet<String>();
            while (roles.hasNext()) {
                extraRoleNames.add(((SimplePrincipal)roles.next()).getName());
            }
            runAsRole = new RunAsIdentity(runAs.value(), principal.getName(), extraRoleNames);
        } else {
            runAsRole = new RunAsIdentity(runAs.value(), null);
        }
        return runAsRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object object = super.invoke(invocation);
        return object;
    }
}

