/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.TransactionRequiredException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.ejb3.entity.ExtendedPersistenceContext;
import org.jboss.ejb3.entity.FlushModeInterceptor;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TxManager;
import org.jboss.tm.TxUtils;

public class ManagedEntityManagerFactory {
    private static final Logger log = Logger.getLogger(ManagedEntityManagerFactory.class);
    public static final String LONG_LIVED_SESSION = "LONG_LIVED_SESSION";
    protected EntityManagerFactory entityManagerFactory;
    protected TransactionLocal session = new TransactionLocal((TransactionManager)TxManager.getInstance());
    protected String jndiName;
    public static ThreadLocal longLivedSession = new ThreadLocal();

    public ManagedEntityManagerFactory(EntityManagerFactory sf) {
        this(sf, "java:comp.ejb3/ManagedEntityManagerFactory");
    }

    public ManagedEntityManagerFactory(EntityManagerFactory sf, String jndiName) {
        this.entityManagerFactory = sf;
        this.jndiName = jndiName;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void destroy() {
        this.entityManagerFactory.close();
    }

    public TransactionLocal getTransactionSession() {
        return this.session;
    }

    public void registerPersistenceContext() {
        this.getSession();
    }

    public EntityManager getSession() {
        Transaction tx = this.session.getTransaction();
        if (tx == null) {
            throw new TransactionRequiredException("EntityManager must be access within a transaction");
        }
        if (!TxUtils.isActive((Transaction)tx)) {
            throw new TransactionRequiredException("Transaction must be active to access EntityManager");
        }
        EntityManager rtnSession = (EntityManager)this.session.get();
        if (rtnSession == null) {
            log.debug((Object)"GETTING NEW EntityManager");
            Map propagated = (Map)longLivedSession.get();
            if (propagated != null) {
                log.debug((Object)("logLivedSession.get() was NOT NULL: " + this.jndiName));
                ExtendedPersistenceContext pc = (ExtendedPersistenceContext)propagated.get(this.jndiName);
                rtnSession = pc.getPersistenceContext();
            } else {
                log.debug((Object)"logLivedSession.get() was NULL");
            }
            boolean closeAtTxCompletion = false;
            if (rtnSession == null) {
                closeAtTxCompletion = true;
                rtnSession = this.createEntityManager(PersistenceContextType.TRANSACTION);
                log.debug((Object)"LONG LIVED NOT FOUND");
            } else {
                log.debug((Object)"using LONG LIVED!!!");
            }
            try {
                tx.registerSynchronization((Synchronization)new SessionSynchronization(rtnSession, tx, closeAtTxCompletion));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
            this.session.set((Object)rtnSession);
        }
        return rtnSession;
    }

    public EntityManager createEntityManager(PersistenceContextType type) {
        return this.entityManagerFactory.createEntityManager(type);
    }

    private static class SessionSynchronization
    implements Synchronization {
        private EntityManager manager;
        private Transaction tx;
        private boolean closeAtTxCompletion;

        public SessionSynchronization(EntityManager session, Transaction tx, boolean close) {
            this.manager = session;
            this.tx = tx;
            this.closeAtTxCompletion = close;
        }

        public void beforeCompletion() {
            try {
                int status = this.tx.getStatus();
                if (status != 4 && status != 9 && status != 1 && FlushModeInterceptor.getTxFlushMode() != FlushModeType.NEVER) {
                    log.debug((Object)"************** flushing.....");
                    this.manager.flush();
                }
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }

        public void afterCompletion(int status) {
            if (this.closeAtTxCompletion) {
                log.debug((Object)"************** closing entity managersession **************");
                this.manager.close();
            }
        }
    }
}

