/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javassist.bytecode.ClassFile;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.Entity;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.Ejb3HandlerFactory;
import org.jboss.ejb3.EjbLinkResolver;
import org.jboss.ejb3.EjbManagerMBean;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.entity.EntityManagerDeployment;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.logging.Logger;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.util.file.ClassFileFilter;

public abstract class Ejb3Deployment
implements EjbLinkResolver {
    private static final Logger log = Logger.getLogger(Ejb3Deployment.class);
    public static final String ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT = "java:/ActualEntityManagerFactories";
    public static final String MANAGED_ENTITY_FACTORY_CONTEXT = "java:/managedEntityFactories";
    protected DeploymentUnit di;
    protected LinkedHashMap containers = new LinkedHashMap();
    protected boolean hasEntities;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected ManagedEntityManagerFactory managedFactory;
    protected EntityManagerDeployment entityDeployment;
    protected String defaultSLSBDomain = "Stateless Bean";
    protected String defaultSFSBDomain = "Stateful Bean";
    protected String defaultMDBDomain = "Message Driven Bean";
    protected String defaultMessageInflowDrivenDomain = "Message Inflow Driven Bean";
    protected String defaultConsumerDomain = "Consumer Bean";
    protected String defaultServiceDomain = "Service Bean";
    protected InitialContext initialContext;
    protected String defaultClientBinding = "socket://0.0.0.0:3873";
    protected KernelAbstraction kernelAbstraction;
    protected MBeanServer mbeanServer;

    public Ejb3Deployment(DeploymentUnit di) {
        this.di = di;
        try {
            this.initialContext = EJB3Util.getInitialContext(di.getJndiProperties());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public KernelAbstraction getKernelAbstraction() {
        return this.kernelAbstraction;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.di;
    }

    public String getDefaultSLSBDomain() {
        return this.defaultSLSBDomain;
    }

    public String getDefaultClientBinding() {
        return this.defaultClientBinding;
    }

    public void setDefaultSLSBDomain(String defaultSLSBDomain) {
        this.defaultSLSBDomain = defaultSLSBDomain;
    }

    public String getDefaultSFSBDomain() {
        return this.defaultSFSBDomain;
    }

    public String getDefaultConsumerDomain() {
        return this.defaultConsumerDomain;
    }

    public void setDefaultSFSBDomain(String defaultSFSBDomain) {
        this.defaultSFSBDomain = defaultSFSBDomain;
    }

    public String getDefaultMDBDomain() {
        return this.defaultMDBDomain;
    }

    public String getDefaultMessageInflowDrivenBeanDomain() {
        return this.defaultMessageInflowDrivenDomain;
    }

    public void setDefaultMDBDomain(String defaultMDBDomain) {
        this.defaultMDBDomain = defaultMDBDomain;
    }

    public String getDefaultServiceDomain() {
        return this.defaultServiceDomain;
    }

    public void setDefaultServiceDomain(String defaultServiceDomain) {
        this.defaultServiceDomain = defaultServiceDomain;
    }

    protected String getJaccContextId() {
        return this.di.getShortName();
    }

    public Container getContainer(ObjectName name) {
        return (Container)this.containers.get(name);
    }

    public Map getContainers() {
        return this.containers;
    }

    public String getEjbJndiName(String ejbLink, Class businessIntf) {
        for (Container container : this.containers.values()) {
            if (!container.getEjbName().equals(ejbLink)) continue;
            return ProxyFactoryHelper.getJndiName(((EjbManagerMBean)((Object)container)).getInstance(), businessIntf);
        }
        return null;
    }

    protected void registerContainer(Container container) throws Exception {
        ObjectName on = container.getObjectName();
        this.containers.put(on, container);
        container.setEjbLinkResolver(this);
        DependencyPolicy policy = this.createDependencyPolicy();
        container.setDependencyPolicy(policy);
        this.kernelAbstraction.install(on.toString(), policy, container);
        log.debug((Object)("Bound ejb3 container " + on));
    }

    protected abstract PolicyConfiguration createPolicyConfiguration() throws Exception;

    protected abstract void initializeJacc(PolicyConfiguration var1, DeploymentUnit var2);

    public void create() throws Exception {
        long start = System.currentTimeMillis();
        PolicyConfiguration pc = this.createPolicyConfiguration();
        this.deploy();
        this.initializeManagedEntityManagerFactory();
        for (Object o : this.containers.values()) {
            Container con = (Container)o;
            this.registerContainer(con);
        }
        this.initializeJacc(pc, this.di);
        log.info((Object)("EJB3 deployment time took: " + (System.currentTimeMillis() - start)));
    }

    protected void deploy() throws Exception {
        Ejb3HandlerFactory factory = Ejb3HandlerFactory.getInstance(this);
        if (this.di.getUrl() != null) {
            this.deployUrl(factory);
        }
        if (this.di.getClasses() != null) {
            for (Class explicit : this.di.getClasses()) {
                if (explicit.isAnnotationPresent(Entity.class)) continue;
                String name = explicit.getName().replace('.', '/') + ".class";
                InputStream stream = explicit.getClassLoader().getResourceAsStream(name);
                this.deployElement(stream, factory, this.initialContext);
            }
        }
    }

    protected void deployUrl(Ejb3HandlerFactory factory) throws Exception {
        Iterator it = ArchiveBrowser.getBrowser((URL)this.di.getUrl(), (ArchiveBrowser.Filter)new ClassFileFilter());
        InitialContext ctx = this.initialContext;
        while (it.hasNext()) {
            InputStream stream = (InputStream)it.next();
            this.deployElement(stream, factory, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployElement(InputStream stream, Ejb3HandlerFactory factory, InitialContext ctx) throws Exception {
        DataInputStream dstream = new DataInputStream(stream);
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
        }
        finally {
            dstream.close();
            stream.close();
        }
        this.deployElement(factory, cf, ctx);
    }

    protected void deployElement(Ejb3HandlerFactory factory, ClassFile cf, InitialContext ctx) throws Exception {
        Ejb3Handler handler = factory.createHandler(cf);
        handler.setCtxProperties(this.di.getJndiProperties());
        if (handler.isEjb() || handler.isJBossBeanType()) {
            List<Container> containers = handler.getContainers(cf, this);
            for (Container con : containers) {
                this.containers.put(con.getObjectName(), con);
            }
        }
    }

    protected void initializeManagedEntityManagerFactory() throws Exception {
        URL persistenceXmlUrl = null;
        persistenceXmlUrl = this.di.getPersistenceXml();
        boolean bl = this.hasEntities = persistenceXmlUrl != null;
        if (!this.hasEntities) {
            return;
        }
        if (this.di.getClasses() != null) {
            for (Class explicit : this.di.getClasses()) {
                if (!explicit.isAnnotationPresent(Entity.class)) continue;
                this.explicitEntityClasses.add(explicit.getName());
            }
        }
        String scopeName = this.containers.size() > 0 ? this.di.getShortName() : null;
        this.entityDeployment = new EntityManagerDeployment(this.initialContext, this.di, this.explicitEntityClasses, persistenceXmlUrl, scopeName);
        this.startEntityManagerDeployment();
    }

    public abstract DependencyPolicy createDependencyPolicy();

    protected void startEntityManagerDeployment() {
        if (this.entityDeployment != null) {
            String ds;
            DependencyPolicy policy = this.createDependencyPolicy();
            if (this.entityDeployment.getXml().getJtaDatasource() != null) {
                ds = this.entityDeployment.getXml().getJtaDatasource();
                policy.addDatasource(ds);
            }
            if (this.entityDeployment.getXml().getDatasource() != null) {
                ds = this.entityDeployment.getXml().getDatasource();
                policy.addDatasource(ds);
            }
            this.kernelAbstraction.install(this.entityDeployment.getKernelName(), policy, this.entityDeployment);
        }
    }

    protected void stopEntityManagerDeployment() {
        if (this.entityDeployment != null) {
            this.kernelAbstraction.uninstall(this.entityDeployment.getKernelName());
        }
    }

    public EntityManagerDeployment getEntityManagerDeployment(String name) {
        if (this.entityDeployment == null) {
            return null;
        }
        if (this.entityDeployment.getEntityManagerName().equals(name)) {
            return this.entityDeployment;
        }
        return null;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        for (Object o : this.containers.keySet()) {
            ObjectName on = (ObjectName)o;
            this.kernelAbstraction.uninstall(on.toString());
        }
        this.stopEntityManagerDeployment();
    }

    public void destroy() throws Exception {
        PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        PolicyConfiguration pc = pcFactory.getPolicyConfiguration(this.getJaccContextId(), true);
        pc.delete();
    }
}

