/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;
import org.jboss.logging.Logger;
import org.jboss.resource.connectionmanager.BaseConnectionManager2;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.ConnectionListener;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;

public class NoTxConnectionManager
extends BaseConnectionManager2 {
    public NoTxConnectionManager() {
    }

    public NoTxConnectionManager(CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy) {
        super(ccm, poolingStrategy);
    }

    public ConnectionListener createConnectionListener(ManagedConnection mc, Object context) {
        NoTxConnectionEventListener cli = new NoTxConnectionEventListener(mc, this.poolingStrategy, context, this.log);
        mc.addConnectionEventListener((ConnectionEventListener)cli);
        return cli;
    }

    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
        if (cl.isManagedConnectionFree()) {
            this.returnManagedConnection(cl, false);
        }
    }

    private class NoTxConnectionEventListener
    extends BaseConnectionManager2.BaseConnectionEventListener {
        private NoTxConnectionEventListener(ManagedConnection mc, ManagedConnectionPool mcp, Object context, Logger log) {
            super(mc, mcp, context, log);
        }

        public void connectionClosed(ConnectionEvent ce) {
            try {
                NoTxConnectionManager.this.getCcm().unregisterConnection(NoTxConnectionManager.this, ce.getConnectionHandle());
            }
            catch (Throwable t) {
                this.log.info((Object)"Throwable from unregisterConnection", t);
            }
            NoTxConnectionManager.this.unregisterAssociation(this, ce.getConnectionHandle());
            if (this.isManagedConnectionFree()) {
                NoTxConnectionManager.this.returnManagedConnection(this, false);
            }
        }

        public void localTransactionStarted(ConnectionEvent ce) {
        }

        public void localTransactionCommitted(ConnectionEvent ce) {
        }

        public void localTransactionRolledback(ConnectionEvent ce) {
        }
    }
}

