/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.spi;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;

public class MethodInfoHashing {
    public static long methodHash(MethodInfo methodInfo) throws Exception {
        TypeInfo[] typeInfoArray = methodInfo.getParameterTypes();
        String string = methodInfo.getName() + "(";
        for (int i = 0; i < typeInfoArray.length; ++i) {
            string = string + MethodInfoHashing.getTypeString(typeInfoArray[i]);
        }
        string = string + ")" + MethodInfoHashing.getTypeString(methodInfo.getReturnType());
        return MethodInfoHashing.createHash(string);
    }

    public static long createHash(String string) throws Exception {
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
        dataOutputStream.writeUTF(string);
        dataOutputStream.flush();
        byte[] byArray = messageDigest.digest();
        for (int i = 0; i < Math.min(8, byArray.length); ++i) {
            l += (long)(byArray[i] & 0xFF) << i * 8;
        }
        return l;
    }

    static String getTypeString(TypeInfo typeInfo) {
        if (typeInfo == PrimitiveInfo.BYTE) {
            return "B";
        }
        if (typeInfo == PrimitiveInfo.CHAR) {
            return "C";
        }
        if (typeInfo == PrimitiveInfo.DOUBLE) {
            return "D";
        }
        if (typeInfo == PrimitiveInfo.FLOAT) {
            return "F";
        }
        if (typeInfo == PrimitiveInfo.INT) {
            return "I";
        }
        if (typeInfo == PrimitiveInfo.LONG) {
            return "J";
        }
        if (typeInfo == PrimitiveInfo.SHORT) {
            return "S";
        }
        if (typeInfo == PrimitiveInfo.BOOLEAN) {
            return "Z";
        }
        if (typeInfo == PrimitiveInfo.VOID) {
            return "V";
        }
        if (typeInfo instanceof ArrayInfo) {
            ArrayInfo arrayInfo = (ArrayInfo)typeInfo;
            return "[" + MethodInfoHashing.getTypeString(arrayInfo.getComponentType());
        }
        return "L" + typeInfo.getName().replace('.', '/') + ";";
    }
}

