/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jboss.reflect.plugins.AnnotationHolder;
import org.jboss.reflect.plugins.ParameterInfoImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class MethodInfoImpl
extends AnnotationHolder
implements MethodInfo {
    private static final long serialVersionUID = 3257007670035756341L;
    protected String name;
    protected Method method;
    protected ClassInfo declaringClass;
    protected TypeInfo[] parameterTypes;
    protected ParameterInfo[] parameters;
    protected ClassInfo[] exceptionTypes;
    protected int modifiers;
    protected TypeInfo returnType;
    protected int hash;

    public MethodInfoImpl() {
    }

    public MethodInfoImpl(AnnotationValue[] annotationValueArray, String string, TypeInfo typeInfo, TypeInfo[] typeInfoArray, ClassInfo[] classInfoArray, int n, ClassInfo classInfo) {
        super(annotationValueArray);
        this.name = string;
        if (typeInfoArray == null) {
            this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
            this.parameters = MethodInfo.NO_PARAMS;
        } else {
            this.parameterTypes = typeInfoArray;
            this.parameters = new ParameterInfoImpl[typeInfoArray.length];
            for (int i = 0; i < typeInfoArray.length; ++i) {
                this.parameters[i] = new ParameterInfoImpl(null, null, typeInfoArray[i]);
            }
        }
        this.exceptionTypes = classInfoArray == null ? MethodInfo.NO_EXCEPTIONS : classInfoArray;
        this.modifiers = n;
        this.declaringClass = classInfo;
        this.returnType = typeInfo;
        this.calculateHash();
    }

    public MethodInfoImpl(AnnotationValue[] annotationValueArray, String string, TypeInfo typeInfo, ParameterInfo[] parameterInfoArray, ClassInfo[] classInfoArray, int n, ClassInfo classInfo) {
        super(annotationValueArray);
        this.name = string;
        if (parameterInfoArray == null || parameterInfoArray.length == 0) {
            this.parameterTypes = MethodInfo.NO_PARAMS_TYPES;
            this.parameters = MethodInfo.NO_PARAMS;
        } else {
            this.parameters = parameterInfoArray;
            this.parameterTypes = new TypeInfo[parameterInfoArray.length];
            for (int i = 0; i < parameterInfoArray.length; ++i) {
                this.parameterTypes[i] = parameterInfoArray[i].getParameterType();
            }
        }
        this.exceptionTypes = classInfoArray == null || classInfoArray.length == 0 ? MethodInfo.NO_EXCEPTIONS : classInfoArray;
        this.modifiers = n;
        this.declaringClass = classInfo;
        this.returnType = typeInfo;
        this.calculateHash();
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public ClassInfo getDeclaringClass() {
        return this.declaringClass;
    }

    public TypeInfo[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ParameterInfo[] getParameters() {
        return this.parameters;
    }

    public ClassInfo[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public TypeInfo getReturnType() {
        return this.returnType;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    protected void toString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append("name=").append(this.name);
        jBossStringBuilder.append(Arrays.asList(this.parameterTypes));
        jBossStringBuilder.append(" return=").append((Object)this.returnType);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof MethodInfoImpl)) {
            return false;
        }
        MethodInfoImpl methodInfoImpl = (MethodInfoImpl)object;
        if (!this.declaringClass.equals(methodInfoImpl.declaringClass)) {
            return false;
        }
        if (!this.name.equals(methodInfoImpl.name)) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, methodInfoImpl.parameterTypes)) {
            return false;
        }
        return this.returnType.equals(methodInfoImpl.returnType);
    }

    public int hashCode() {
        return this.hash;
    }

    protected void calculateHash() {
        int n = this.name.hashCode();
        n = 29 * n + this.declaringClass.hashCode();
        if (this.parameterTypes != null) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                n = 29 * n + this.parameterTypes[i].hashCode();
            }
        }
        this.hash = n;
    }
}

