/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.InheritableAnnotationHolder;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class ClassInfoImpl
extends InheritableAnnotationHolder
implements ClassInfo {
    private static final long serialVersionUID = 3545798779904340792L;
    static final ClassInfo UNKNOWN_CLASS = new UnknownClassInfo();
    static final InterfaceInfo[] UNKNOWN_INTERFACES = new InterfaceInfo[0];
    static final ConstructorInfo[] UNKNOWN_CONSTRUCTORS = new ConstructorInfo[0];
    static final MethodInfo[] UNKNOWN_METHODS = new MethodInfo[0];
    private static final FieldInfo[] UNKNOWN_FIELDS = new FieldInfo[0];
    protected String name;
    protected int modifiers;
    protected InterfaceInfo[] interfaces = UNKNOWN_INTERFACES;
    protected MethodInfo[] methods = UNKNOWN_METHODS;
    protected FieldInfo[] fields = UNKNOWN_FIELDS;
    protected HashMap fieldMap;
    protected ClassInfo superclass = UNKNOWN_CLASS;
    protected ConstructorInfo[] constructors = UNKNOWN_CONSTRUCTORS;

    public static MethodInfo findMethod(MethodInfo[] methodInfoArray, String string, TypeInfo[] typeInfoArray) {
        if (methodInfoArray == null) {
            return null;
        }
        for (int i = 0; i < methodInfoArray.length; ++i) {
            if (!methodInfoArray[i].getName().equals(string) || methodInfoArray[i].getParameterTypes().length != typeInfoArray.length) continue;
            boolean bl = true;
            for (int j = 0; j < typeInfoArray.length; ++j) {
                if (typeInfoArray[j].equals(methodInfoArray[i].getParameterTypes()[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return methodInfoArray[i];
        }
        return null;
    }

    public ClassInfoImpl() {
    }

    public ClassInfoImpl(String string) {
        this.name = string;
    }

    public ClassInfoImpl(String string, int n, InterfaceInfo[] interfaceInfoArray, ClassInfoImpl classInfoImpl) {
        this.name = string;
        this.modifiers = n;
        this.interfaces = interfaceInfoArray;
        this.superclass = classInfoImpl;
    }

    public void setType(Class clazz) {
        this.setAnnotatedElement(clazz);
    }

    public void setInterfaces(InterfaceInfo[] interfaceInfoArray) {
        this.interfaces = interfaceInfoArray;
    }

    public void setDeclaredMethods(MethodInfoImpl[] methodInfoImplArray) {
        this.methods = methodInfoImplArray;
        if (methodInfoImplArray != null) {
            for (int i = 0; i < methodInfoImplArray.length; ++i) {
                methodInfoImplArray[i].declaringClass = this;
            }
        }
    }

    public void setDeclaredFields(FieldInfoImpl[] fieldInfoImplArray) {
        this.fields = fieldInfoImplArray;
        if (fieldInfoImplArray != null) {
            for (int i = 0; i < fieldInfoImplArray.length; ++i) {
                fieldInfoImplArray[i].declaringClass = this;
            }
        }
    }

    public void setDeclaredConstructors(ConstructorInfoImpl[] constructorInfoImplArray) {
        this.constructors = constructorInfoImplArray;
        if (constructorInfoImplArray != null) {
            for (int i = 0; i < constructorInfoImplArray.length; ++i) {
                constructorInfoImplArray[i].declaringClass = this;
            }
        }
    }

    public void setSuperclass(ClassInfo classInfo) {
        this.superclass = classInfo;
    }

    public boolean isInterface() {
        return false;
    }

    public InterfaceInfo[] getInterfaces() {
        if (this.interfaces == UNKNOWN_INTERFACES) {
            this.setInterfaces(this.typeInfoFactory.getInterfaces(this.getType()));
        }
        return this.interfaces;
    }

    public MethodInfo getDeclaredMethod(String string, TypeInfo[] typeInfoArray) {
        return ClassInfoImpl.findMethod(this.methods, string, typeInfoArray);
    }

    public MethodInfo[] getDeclaredMethods() {
        if (this.methods == UNKNOWN_METHODS) {
            this.setDeclaredMethods(this.typeInfoFactory.getMethods(this.getType(), this));
        }
        return this.methods;
    }

    public FieldInfo getDeclaredField(String string) {
        if (this.fields == UNKNOWN_FIELDS) {
            this.setDeclaredFields(this.typeInfoFactory.getFields(this.getType(), this));
        }
        return (FieldInfo)this.fieldMap.get(string);
    }

    public FieldInfo[] getDeclaredFields() {
        if (this.fields == UNKNOWN_FIELDS) {
            this.setDeclaredFields(this.typeInfoFactory.getFields(this.getType(), this));
        }
        return this.fields;
    }

    public ConstructorInfo[] getDeclaredConstructors() {
        if (this.constructors == UNKNOWN_CONSTRUCTORS) {
            this.setDeclaredConstructors(this.typeInfoFactory.getConstructors(this.getType(), this));
        }
        return this.constructors;
    }

    public ClassInfo getSuperclass() {
        if (this.superclass == UNKNOWN_CLASS) {
            this.setSuperclass(this.typeInfoFactory.getSuperClass(this.getType()));
        }
        return this.superclass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return (Class)this.annotatedElement;
    }

    protected InheritableAnnotationHolder getSuperHolder() {
        return (ClassInfoImpl)this.getSuperclass();
    }

    protected void toString(JBossStringBuilder jBossStringBuilder) {
        jBossStringBuilder.append("name=").append(this.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ClassInfoImpl)) {
            return false;
        }
        ClassInfoImpl classInfoImpl = (ClassInfoImpl)object;
        return !(this.name != null ? !this.name.equals(classInfoImpl.name) : classInfoImpl.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    static class UnknownClassInfo
    implements ClassInfo {
        UnknownClassInfo() {
        }

        public ConstructorInfo[] getDeclaredConstructors() {
            return null;
        }

        public FieldInfo getDeclaredField(String string) {
            return null;
        }

        public FieldInfo[] getDeclaredFields() {
            return null;
        }

        public MethodInfo getDeclaredMethod(String string, TypeInfo[] typeInfoArray) {
            return null;
        }

        public MethodInfo[] getDeclaredMethods() {
            return null;
        }

        public InterfaceInfo[] getInterfaces() {
            return null;
        }

        public String getName() {
            return null;
        }

        public ClassInfo getSuperclass() {
            return null;
        }

        public boolean isInterface() {
            return false;
        }

        public AnnotationValue getAnnotation(String string) {
            return null;
        }

        public AnnotationValue[] getAnnotations() {
            return null;
        }

        public boolean isAnnotationPresent(String string) {
            return false;
        }

        public String toShortString() {
            return null;
        }

        public void toShortString(JBossStringBuilder jBossStringBuilder) {
        }

        public Class getType() {
            return null;
        }

        public int getModifiers() {
            return 0;
        }

        public boolean isPublic() {
            return false;
        }

        public boolean isStatic() {
            return false;
        }

        public Object clone() {
            return null;
        }
    }
}

