/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.util.CollectionsFactory;
import org.jboss.util.JBossObject;

public class AbstractController
extends JBossObject
implements Controller {
    protected List states = CollectionsFactory.createCopyOnWriteList();
    protected Map allContexts = CollectionsFactory.createConcurrentReaderMap();
    protected Map contextsByState = CollectionsFactory.createConcurrentReaderMap();
    protected Set errorContexts = CollectionsFactory.createCopyOnWriteSet();
    protected Set installing = CollectionsFactory.createCopyOnWriteSet();
    protected boolean onDemandEnabled = true;

    public AbstractController() throws Exception {
        this.addState(ControllerState.NOT_INSTALLED, null);
        this.addState(ControllerState.DESCRIBED, null);
        this.addState(ControllerState.INSTANTIATED, null);
        this.addState(ControllerState.CONFIGURED, null);
        this.addState(ControllerState.CREATE, null);
        this.addState(ControllerState.START, null);
        this.addState(ControllerState.INSTALLED, null);
    }

    public void addState(ControllerState controllerState, ControllerState controllerState2) {
        if (controllerState2 == null) {
            this.states.add(controllerState);
        } else {
            int n = this.states.indexOf((Object)controllerState2);
            if (n == -1) {
                throw new IllegalStateException((Object)((Object)controllerState2) + " is not a state in the controller.");
            }
            this.states.add(n, controllerState);
        }
        this.contextsByState.put(controllerState, CollectionsFactory.createCopyOnWriteSet());
    }

    public synchronized ControllerContext getContext(Object object, ControllerState controllerState) {
        if (object == null) {
            throw new IllegalArgumentException("Null name");
        }
        ControllerContext controllerContext = (ControllerContext)this.allContexts.get(object);
        if (controllerContext != null && controllerState != null) {
            int n = this.states.indexOf((Object)controllerState);
            if (n == -1) {
                throw new IllegalArgumentException("Unknown state " + (Object)((Object)controllerState) + " states=" + this.states);
            }
            int n2 = this.states.indexOf((Object)controllerContext.getState());
            if (n2 < n) {
                return null;
            }
        }
        return controllerContext;
    }

    public ControllerContext getInstalledContext(Object object) {
        return this.getContext(object, ControllerState.INSTALLED);
    }

    public synchronized Set getNotInstalled() {
        HashSet hashSet = new HashSet(this.errorContexts);
        int n = 0;
        while (!ControllerState.INSTALLED.equals(this.states.get(n))) {
            Set set = (Set)this.contextsByState.get(this.states.get(n));
            hashSet.addAll(set);
            ++n;
        }
        this.errorContexts.clear();
        return hashSet;
    }

    public List getStates() {
        return this.states;
    }

    public synchronized void install(ControllerContext controllerContext) throws Throwable {
        boolean bl = this.log.isTraceEnabled();
        if (controllerContext == null) {
            throw new IllegalArgumentException("Null context");
        }
        Object object = controllerContext.getName();
        if (object == null) {
            throw new IllegalArgumentException("Null name " + controllerContext.toShortString());
        }
        if (this.allContexts.get(object) != null) {
            throw new IllegalStateException("Already installed " + object);
        }
        this.install(controllerContext, bl);
    }

    public synchronized void change(ControllerContext controllerContext, ControllerState controllerState) throws Throwable {
        boolean bl = this.log.isTraceEnabled();
        if (controllerContext == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (controllerState == null) {
            throw new IllegalArgumentException("Null state");
        }
        this.change(controllerContext, controllerState, bl);
    }

    public synchronized void enableOnDemand(ControllerContext controllerContext) throws Throwable {
        boolean bl = this.log.isTraceEnabled();
        if (controllerContext == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.enableOnDemand(controllerContext, bl);
    }

    public synchronized ControllerContext uninstall(Object object) {
        ControllerContext controllerContext;
        boolean bl = this.log.isTraceEnabled();
        if (object == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (this.errorContexts.remove(object) && bl) {
            this.log.trace((Object)("Tidied up context in error state: " + object));
        }
        if ((controllerContext = (ControllerContext)this.allContexts.get(object)) == null) {
            throw new IllegalStateException("Not installed: " + object);
        }
        if (bl) {
            this.log.trace((Object)("Uninstalling " + controllerContext.toShortString()));
        }
        this.uninstallContext(controllerContext, ControllerState.NOT_INSTALLED, bl);
        this.allContexts.remove(object);
        return controllerContext;
    }

    protected void install(ControllerContext controllerContext, boolean bl) throws Throwable {
        Object object = controllerContext.getName();
        if (ControllerMode.AUTOMATIC.equals((Object)controllerContext.getMode())) {
            controllerContext.setRequiredState(ControllerState.INSTALLED);
        }
        if (bl) {
            this.log.trace((Object)("Installing " + controllerContext.toShortString()));
        }
        controllerContext.setController(this);
        DependencyInfo dependencyInfo = controllerContext.getDependencyInfo();
        if (bl) {
            this.log.trace((Object)("Dependencies for " + object + ": " + dependencyInfo.getIDependOn(null)));
        }
        if (!this.incrementState(controllerContext, bl)) {
            this.errorContexts.remove(controllerContext);
            throw controllerContext.getError();
        }
        this.allContexts.put(controllerContext.getName(), controllerContext);
        this.resolveContexts(bl);
    }

    protected void change(ControllerContext controllerContext, ControllerState controllerState, boolean bl) throws Throwable {
        ControllerState controllerState2 = controllerContext.getState();
        int n = this.states.indexOf((Object)controllerState2);
        int n2 = this.states.indexOf((Object)controllerState);
        if (n2 == -1) {
            throw new IllegalArgumentException("Unknown state: " + (Object)((Object)controllerState));
        }
        if (n == n2) {
            if (bl) {
                this.log.trace((Object)("No change required toState=" + controllerState.getStateString() + " " + controllerContext.toShortString()));
            }
            return;
        }
        if (bl) {
            this.log.trace((Object)("Change toState=" + controllerState.getStateString() + " " + controllerContext.toShortString()));
        }
        controllerContext.setRequiredState(controllerState);
        if (n < n2) {
            this.resolveContexts(bl);
        } else {
            while (n > n2) {
                this.uninstallContext(controllerContext, bl);
                n = this.states.indexOf((Object)controllerContext.getState());
            }
        }
    }

    protected void enableOnDemand(ControllerContext controllerContext, boolean bl) throws Throwable {
        if (!ControllerMode.ON_DEMAND.equals((Object)controllerContext.getMode())) {
            throw new IllegalStateException("Context is not ON DEMAND: " + controllerContext.toShortString());
        }
        if (!this.allContexts.containsKey(controllerContext.getName())) {
            throw new IllegalStateException("Unknown context: " + controllerContext.toShortString());
        }
        if (ControllerState.INSTALLED.equals((Object)controllerContext.getRequiredState())) {
            return;
        }
        controllerContext.setRequiredState(ControllerState.INSTALLED);
        if (bl) {
            this.log.trace((Object)("Enable onDemand: " + controllerContext.toShortString()));
        }
        this.onDemandEnabled = true;
    }

    protected boolean incrementState(ControllerContext controllerContext, boolean bl) {
        ControllerState controllerState = controllerContext.getState();
        Set set = null;
        int n = -1;
        if (ControllerState.ERROR.equals((Object)controllerState)) {
            this.errorContexts.remove(controllerContext);
            try {
                this.install(controllerContext, ControllerState.ERROR, ControllerState.NOT_INSTALLED);
            }
            catch (Throwable throwable) {
                this.log.error((Object)("Error during initial installation: " + controllerContext.toShortString()), throwable);
                controllerContext.setError(throwable);
                this.errorContexts.add(controllerContext);
                return false;
            }
            Set set2 = (Set)this.contextsByState.get((Object)ControllerState.NOT_INSTALLED);
            set2.add(controllerContext);
        } else {
            n = this.states.indexOf((Object)controllerState);
            set = (Set)this.contextsByState.get((Object)controllerState);
            if (!set.contains(controllerContext)) {
                throw new IllegalStateException("Context not found in previous state: " + controllerContext.toShortString());
            }
        }
        int n2 = n + 1;
        ControllerState controllerState2 = (ControllerState)((Object)this.states.get(n2));
        Set set3 = (Set)this.contextsByState.get((Object)controllerState2);
        try {
            this.install(controllerContext, controllerState, controllerState2);
        }
        catch (Throwable throwable) {
            this.log.error((Object)("Error installing to " + controllerState2.getStateString() + ": " + controllerContext.toShortString()), throwable);
            this.uninstallContext(controllerContext, ControllerState.NOT_INSTALLED, bl);
            controllerContext.setError(throwable);
            this.errorContexts.add(controllerContext);
            return false;
        }
        if (set != null) {
            set.remove(controllerContext);
        }
        set3.add(controllerContext);
        return true;
    }

    protected void resolveContexts(boolean bl) {
        ControllerState controllerState;
        ControllerState controllerState2;
        int n;
        boolean bl2 = true;
        block0: while (bl2 || this.onDemandEnabled) {
            this.onDemandEnabled = false;
            bl2 = false;
            for (n = 0; n < this.states.size() - 1; ++n) {
                controllerState2 = (ControllerState)((Object)this.states.get(n));
                if (!this.resolveContexts(controllerState2, controllerState = (ControllerState)((Object)this.states.get(n + 1)), bl)) continue;
                bl2 = true;
                continue block0;
            }
        }
        if (bl) {
            for (n = 0; n < this.states.size() - 1; ++n) {
                controllerState2 = (ControllerState)((Object)this.states.get(n));
                controllerState = (ControllerState)((Object)this.states.get(n + 1));
                Set set = (Set)this.contextsByState.get((Object)controllerState2);
                if (set.isEmpty()) continue;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ControllerContext controllerContext = (ControllerContext)iterator.next();
                    if (!this.advance(controllerContext)) continue;
                    this.log.trace((Object)("Still unresolved " + controllerState.getStateString() + ": " + controllerContext));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveContexts(ControllerState controllerState, ControllerState controllerState2, boolean bl) {
        boolean bl2 = false;
        Set set = (Set)this.contextsByState.get((Object)controllerState);
        Set set2 = this.resolveContexts(set, controllerState2, bl);
        if (!set2.isEmpty()) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                ControllerContext controllerContext = (ControllerContext)iterator.next();
                Object object = controllerContext.getName();
                if (!this.installing.add(controllerContext)) {
                    if (!bl) continue;
                    this.log.trace((Object)("Already installing " + object + " for " + controllerState2.getStateString()));
                    continue;
                }
                try {
                    if (bl) {
                        this.log.trace((Object)("Dependencies resolved " + object + " for " + controllerState2.getStateString()));
                    }
                    if (!this.incrementState(controllerContext, bl)) continue;
                    bl2 = true;
                    if (!bl) continue;
                    this.log.trace((Object)(object + " " + controllerState2.getStateString()));
                }
                finally {
                    this.installing.remove(controllerContext);
                }
            }
        }
        return bl2;
    }

    protected Set resolveContexts(Set set, ControllerState controllerState, boolean bl) {
        HashSet<ControllerContext> hashSet = new HashSet<ControllerContext>();
        if (!set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                DependencyInfo dependencyInfo;
                ControllerContext controllerContext = (ControllerContext)iterator.next();
                if (!this.advance(controllerContext) || !(dependencyInfo = controllerContext.getDependencyInfo()).resolveDependencies(this, controllerState)) continue;
                hashSet.add(controllerContext);
            }
        }
        return hashSet;
    }

    protected void uninstallContext(ControllerContext controllerContext, ControllerState controllerState, boolean bl) {
        ControllerState controllerState2;
        int n;
        int n2 = this.states.indexOf((Object)controllerState);
        if (n2 == -1) {
            this.log.error((Object)("Internal error unknown state " + (Object)((Object)controllerState) + " states=" + this.states));
        }
        if ((n = this.states.indexOf((Object)(controllerState2 = controllerContext.getState()))) == -1) {
            this.log.error((Object)("Internal error during uninstall current state not found: " + controllerContext.toShortString()));
        }
        if (n2 > n) {
            this.log.error((Object)("Internal error during uninstall: toState=" + (Object)((Object)controllerState) + " context=" + controllerContext.toShortString()));
            return;
        }
        for (int i = n; i >= n2; --i) {
            this.uninstallContext(controllerContext, bl);
        }
    }

    protected void uninstallContext(ControllerContext controllerContext, boolean bl) {
        int n;
        Object object;
        Object object2;
        Set set;
        Object object3 = controllerContext.getName();
        ControllerState controllerState = controllerContext.getState();
        int n2 = this.states.indexOf((Object)controllerState);
        if (bl) {
            this.log.trace((Object)("Uninstalling " + object3 + " from " + controllerState.getStateString()));
        }
        if (!(set = (Set)this.contextsByState.get((Object)controllerState)).remove(controllerContext)) {
            throw new IllegalStateException("Context not found in previous state " + controllerState.getStateString() + " context=" + controllerContext.toShortString());
        }
        DependencyInfo dependencyInfo = controllerContext.getDependencyInfo();
        Set set2 = dependencyInfo.getDependsOnMe(null);
        if (!set2.isEmpty()) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                int n3;
                int n4;
                object2 = (DependencyItem)iterator.next();
                if (!object2.isResolved() || (object = object2.getDependentState()) != null && !((ControllerState)((Object)object)).equals((Object)controllerState)) continue;
                object2.unresolved(this);
                ControllerContext controllerContext2 = this.getContext(object2.getName(), null);
                if (controllerContext2 == null) continue;
                ControllerState controllerState2 = object2.getWhenRequired();
                if (controllerState2 == null) {
                    controllerState2 = ControllerState.NOT_INSTALLED;
                }
                if ((n4 = this.states.indexOf((Object)controllerState2)) > (n3 = this.states.indexOf((Object)controllerContext2.getState()))) continue;
                this.uninstallContext(controllerContext2, controllerState2, bl);
            }
        }
        if ((n = n2 - 1) == -1) {
            controllerContext.setError(new IllegalStateException("Cannot uninstall from " + (Object)((Object)controllerState)));
            return;
        }
        object2 = (ControllerState)((Object)this.states.get(n));
        object = (Set)this.contextsByState.get(object2);
        object.add(controllerContext);
        try {
            this.uninstall(controllerContext, controllerState, (ControllerState)((Object)object2));
        }
        catch (Throwable throwable) {
            this.log.warn((Object)("Error uninstalling from " + controllerState.getStateString() + ": " + controllerContext.toShortString()), throwable);
        }
    }

    protected void install(ControllerContext controllerContext, ControllerState controllerState, ControllerState controllerState2) throws Throwable {
        controllerContext.install(controllerState, controllerState2);
    }

    protected void uninstall(ControllerContext controllerContext, ControllerState controllerState, ControllerState controllerState2) {
        controllerContext.uninstall(controllerState, controllerState2);
    }

    protected boolean advance(ControllerContext controllerContext) {
        ControllerState controllerState;
        int n;
        ControllerMode controllerMode = controllerContext.getMode();
        if (ControllerMode.DISABLED.equals((Object)controllerMode)) {
            return false;
        }
        ControllerState controllerState2 = controllerContext.getState();
        int n2 = this.states.indexOf((Object)controllerState2);
        return n2 < (n = this.states.indexOf((Object)(controllerState = controllerContext.getRequiredState())));
    }
}

