/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.services;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.services.ConfigObjectCreateRule;
import org.apache.commons.services.Module;
import org.apache.commons.services.Service;

public class ServiceModule
extends Module {
    protected Map services = null;

    protected void initServices() {
        this.services = new HashMap();
    }

    public ServiceModule() {
        this.initServices();
    }

    public void init() {
        super.init();
        this.services.clear();
    }

    public void destroy() {
        super.destroy();
        Iterator iterator = this.services.values().iterator();
        Service service = null;
        while (iterator.hasNext()) {
            service = (Service)iterator.next();
            service.destroy();
        }
        this.services.clear();
        this.services = null;
    }

    public void addService(Service service) {
        this.services.put(service.getName(), service);
        service.setParentModule(this);
        System.out.println("------------- addService " + service + " with name = " + service.getName());
    }

    public void removeService(String name) {
        this.services.remove(name);
    }

    public Service getService(String name) throws Exception {
        Service service = (Service)this.services.get(name);
        if (service == null) {
            throw new Exception("Service not found for name - '" + name + "'");
        }
        return service;
    }

    public Iterator getServices() {
        return this.services.values().iterator();
    }

    public Digester initDigester(Digester digester, String path) {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("Module can not be used alone. The path argument is mandatory.");
        }
        String servicePath = path + "/service";
        digester.addRule(servicePath, (Rule)new ConfigObjectCreateRule(digester, "", "type", servicePath));
        digester.addSetNext(servicePath, "addService", "org.apache.commons.services.Service");
        digester.addSetProperties(servicePath);
        digester.addSetProperty(servicePath + "/set-property", "property", "value");
        return digester;
    }
}

