/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging.jms;

import com.icesoft.net.messaging.jms.JMSAdapter;
import com.icesoft.net.messaging.jms.JMSConnection;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJMSConnection
implements JMSConnection {
    private static final Log LOG = LogFactory.getLog((Class)AbstractJMSConnection.class);
    protected final Object connectionLock = new Object();
    protected JMSAdapter jmsAdapter;
    protected Topic topic;
    protected TopicConnection topicConnection;
    protected TopicSession topicSession;
    protected int acknowledgeMode;
    protected boolean connected = false;

    protected AbstractJMSConnection(Topic topic, JMSAdapter jmsAdapter, int acknowledgeMode) throws IllegalArgumentException {
        if (topic == null) {
            throw new IllegalArgumentException("topic is null");
        }
        if (jmsAdapter == null) {
            throw new IllegalArgumentException("jmsAdapter is null");
        }
        this.topic = topic;
        this.jmsAdapter = jmsAdapter;
        this.acknowledgeMode = acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (this.connected) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connected) {
                    JMSException _jmsException;
                    block12: {
                        _jmsException = null;
                        try {
                            if (this.topicSession != null) {
                                this.topicSession.close();
                            }
                        }
                        catch (JMSException exception) {
                            _jmsException = exception;
                        }
                        try {
                            if (this.topicConnection != null) {
                                this.topicConnection.close();
                            }
                        }
                        catch (JMSException exception) {
                            if (_jmsException != null) break block12;
                            _jmsException = exception;
                        }
                    }
                    this.topicSession = null;
                    this.topicConnection = null;
                    this.connected = false;
                    if (_jmsException != null) {
                        throw _jmsException;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws JMSException, JMSSecurityException {
        if (!this.connected) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (!this.connected) {
                    this.topicConnection = this.jmsAdapter.getTopicConnectionFactory().createTopicConnection();
                    this.topicSession = this.topicConnection.createTopicSession(false, this.acknowledgeMode);
                    this.connected = true;
                }
            }
        }
    }

    protected static String toString(Message message) {
        StringBuffer _messageString;
        block6: {
            _messageString = new StringBuffer();
            try {
                Enumeration _propertyNames = message.getPropertyNames();
                while (_propertyNames.hasMoreElements()) {
                    String _propertyName = (String)_propertyNames.nextElement();
                    _messageString.append(_propertyName);
                    _messageString.append(": ");
                    _messageString.append(message.getObjectProperty(_propertyName));
                    _messageString.append("\r\n");
                }
                _messageString.append("\r\n");
                if (message instanceof ObjectMessage) {
                    _messageString.append(((ObjectMessage)message).getObject());
                } else if (message instanceof TextMessage) {
                    _messageString.append(((TextMessage)message).getText());
                }
                _messageString.append("\r\n");
            }
            catch (JMSException exception) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)"Failed to get properties due to some internal error!", (Throwable)exception);
            }
        }
        return _messageString.toString();
    }
}

