/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging;

import com.icesoft.net.messaging.MessageServiceAdapter;
import com.icesoft.net.messaging.MessageServiceConfiguration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMessageServiceAdapter
implements MessageServiceAdapter {
    private static final Log LOG = LogFactory.getLog((Class)AbstractMessageServiceAdapter.class);
    protected static final String MESSAGING_PROPERTIES = "com.icesoft.net.messaging.properties";
    protected MessageServiceConfiguration messageServiceConfiguration;
    protected Map topicPublisherMap = new HashMap();
    protected Map topicSubscriberMap = new HashMap();

    protected AbstractMessageServiceAdapter(MessageServiceConfiguration messageServiceConfiguration) throws IllegalArgumentException {
        if (messageServiceConfiguration == null) {
            throw new IllegalArgumentException("messageServiceConfiguration is null");
        }
        this.messageServiceConfiguration = messageServiceConfiguration;
    }

    protected AbstractMessageServiceAdapter(ServletContext servletContext) throws IllegalArgumentException {
        if (servletContext == null) {
            throw new IllegalArgumentException("servletContext is null");
        }
    }

    public MessageServiceConfiguration getMessageServiceConfiguration() {
        return this.messageServiceConfiguration;
    }

    public String[] getPublisherTopicNames() {
        return this.topicPublisherMap.keySet().toArray(new String[this.topicPublisherMap.size()]);
    }

    public String[] getSubscriberTopicNames() {
        return this.topicSubscriberMap.keySet().toArray(new String[this.topicSubscriberMap.size()]);
    }

    public boolean isPublishingOn(String topicName) {
        return topicName != null && topicName.trim().length() != 0 && this.topicPublisherMap.containsKey(topicName);
    }

    public boolean isSubscribedTo(String topicName) {
        return topicName != null && topicName.trim().length() != 0 && this.topicSubscriberMap.containsKey(topicName);
    }
}

