/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.context.View;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.MimeTypeMatcher;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.ServerProxy;
import com.icesoft.faces.webapp.http.common.standard.OKHandler;
import com.icesoft.faces.webapp.http.common.standard.PathDispatcherServer;
import com.icesoft.faces.webapp.http.core.AsyncServerDetector;
import com.icesoft.faces.webapp.http.core.DisposeBeans;
import com.icesoft.faces.webapp.http.core.DisposeViews;
import com.icesoft.faces.webapp.http.core.MultiViewServer;
import com.icesoft.faces.webapp.http.core.ReceivePing;
import com.icesoft.faces.webapp.http.core.ReceiveSendUpdates;
import com.icesoft.faces.webapp.http.core.RequestVerifier;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import com.icesoft.faces.webapp.http.core.SendUpdates;
import com.icesoft.faces.webapp.http.core.SingleViewServer;
import com.icesoft.faces.webapp.http.core.UploadServer;
import com.icesoft.faces.webapp.http.core.ViewBoundServer;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.servlet.EnvironmentAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.util.IdGenerator;
import com.icesoft.util.MonitorRunner;
import edu.emory.mathcs.backport.java.util.concurrent.Semaphore;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainSessionBoundServlet
implements PseudoServlet {
    private static final String ResourcePrefix = "/block/resource/";
    private static final String ResourceRegex = ".*" + "/block/resource/".replaceAll("\\/", "\\/") + ".*";
    private static final Log Log = LogFactory.getLog((Class)MainSessionBoundServlet.class);
    private static final SessionExpired SessionExpired = new SessionExpired();
    private static final Server NOOPServer = new Server(){

        public void service(Request request) throws Exception {
            request.respondWith(OKHandler.HANDLER);
        }

        public void shutdown() {
        }
    };
    private static final Runnable NOOP = new Runnable(){

        public void run() {
        }
    };
    private Runnable drainUpdatedViews = new Runnable(){

        public void run() {
            MainSessionBoundServlet.this.allUpdatedViews.removeAll(MainSessionBoundServlet.this.synchronouslyUpdatedViews);
            if (!MainSessionBoundServlet.this.allUpdatedViews.isEmpty()) {
                Log.warn((Object)((Object)((Object)MainSessionBoundServlet.this.allUpdatedViews) + " views have accumulated updates"));
            }
            MainSessionBoundServlet.this.allUpdatedViews.clear();
        }
    };
    private Map views = Collections.synchronizedMap(new HashMap());
    private ViewQueue allUpdatedViews = new ViewQueue();
    private Collection synchronouslyUpdatedViews = new HashSet();
    private String sessionID;
    private PseudoServlet servlet;
    private ShutdownHook disposeViews;
    private Runnable shutdown;

    public MainSessionBoundServlet(final HttpSession session, final SessionDispatcher.Monitor sessionMonitor, IdGenerator idGenerator, MimeTypeMatcher mimeTypeMatcher, MonitorRunner monitorRunner, Configuration configuration) {
        Server receivePing;
        Server sendUpdates;
        Server sendUpdatedViews;
        Server viewServlet;
        this.sessionID = idGenerator.newIdentifier();
        ContextEventRepeater.iceFacesIdRetrieved(session, this.sessionID);
        ResourceDispatcher resourceDispatcher = new ResourceDispatcher(ResourcePrefix, mimeTypeMatcher, sessionMonitor);
        if (configuration.getAttributeAsBoolean("concurrentDOMViews", false)) {
            viewServlet = new MultiViewServer(session, this.sessionID, sessionMonitor, this.views, this.allUpdatedViews, configuration, resourceDispatcher);
            this.disposeViews = new ShutdownHook(new RequestVerifier(this.sessionID, new DisposeViews(this.views)));
        } else {
            viewServlet = new SingleViewServer(session, this.sessionID, sessionMonitor, this.views, this.allUpdatedViews, configuration, resourceDispatcher);
            this.disposeViews = new ShutdownHook(NOOPServer);
        }
        if (configuration.getAttributeAsBoolean("synchronousUpdate", false)) {
            this.allUpdatedViews.onPut(this.drainUpdatedViews);
            sendUpdatedViews = NOOPServer;
            sendUpdates = NOOPServer;
            receivePing = NOOPServer;
        } else {
            sendUpdatedViews = new RequestVerifier(this.sessionID, new AsyncServerDetector(this.sessionID, this.synchronouslyUpdatedViews, this.allUpdatedViews, session.getServletContext(), monitorRunner, configuration));
            sendUpdates = new RequestVerifier(this.sessionID, new SendUpdates(this.views));
            receivePing = new RequestVerifier(this.sessionID, new ReceivePing(this.views));
        }
        UploadServer upload = new UploadServer(this.views, configuration);
        RequestVerifier receiveSendUpdates = new RequestVerifier(this.sessionID, new ViewBoundServer(new ReceiveSendUpdates(this.views, this.synchronouslyUpdatedViews), sessionMonitor, this.views));
        PathDispatcherServer dispatcher = new PathDispatcherServer();
        dispatcher.dispatchOn(".*block\\/send\\-receive\\-updates$", receiveSendUpdates);
        dispatcher.dispatchOn(".*block\\/receive\\-updated\\-views$", sendUpdatedViews);
        dispatcher.dispatchOn(".*block\\/receive\\-updates$", sendUpdates);
        dispatcher.dispatchOn(".*block\\/ping$", receivePing);
        dispatcher.dispatchOn(".*block\\/dispose\\-views$", this.disposeViews);
        dispatcher.dispatchOn(ResourceRegex, resourceDispatcher);
        dispatcher.dispatchOn(".*uploadHtml", upload);
        dispatcher.dispatchOn(".*", viewServlet);
        this.servlet = new EnvironmentAdaptingServlet(dispatcher, configuration, session.getServletContext());
        this.shutdown = new Runnable(){

            public void run() {
                MainSessionBoundServlet.this.shutdown = NOOP;
                Iterator i = MainSessionBoundServlet.this.views.values().iterator();
                while (i.hasNext()) {
                    CommandQueue commandQueue = (CommandQueue)i.next();
                    commandQueue.put(SessionExpired);
                }
                if (sessionMonitor.isExpired()) {
                    MainSessionBoundServlet.this.disposeViews.waitForViewsShutdown();
                }
                DisposeBeans.in(session);
                ContextEventRepeater.iceFacesIdDisposed(session, MainSessionBoundServlet.this.sessionID);
                MainSessionBoundServlet.this.servlet.shutdown();
                Iterator viewIterator = MainSessionBoundServlet.this.views.values().iterator();
                while (viewIterator.hasNext()) {
                    View view = (View)viewIterator.next();
                    view.dispose();
                }
            }
        };
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.servlet.service(request, response);
    }

    public void shutdown() {
        this.shutdown.run();
    }

    public Map getViews() {
        return this.views;
    }

    public ViewQueue getAllUpdatedViews() {
        return this.allUpdatedViews;
    }

    public Collection getSynchronouslyUpdatedViews() {
        return this.synchronouslyUpdatedViews;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    private class ShutdownHook
    extends ServerProxy {
        public ShutdownHook(Server server) {
            super(server);
        }

        public void waitForViewsShutdown() {
            int size = MainSessionBoundServlet.this.views.size();
            final Semaphore lock = new Semaphore(size, true);
            this.server = new ServerProxy(this.server){

                public void service(Request request) throws Exception {
                    lock.release();
                    super.service(request);
                }
            };
            try {
                lock.acquire(size);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                lock.tryAcquire(size, 15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Log.warn((Object)"Some views failed to confirm their shutdown.");
            }
        }
    }
}

