/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.webapp.http.common.FileLocator;
import com.icesoft.faces.webapp.http.common.MimeTypeMatcher;
import com.icesoft.faces.webapp.http.core.DisposeBeans;
import com.icesoft.faces.webapp.http.core.ResourceServer;
import com.icesoft.faces.webapp.http.core.SessionExpiredServer;
import com.icesoft.faces.webapp.http.servlet.BasicAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.MainSessionBoundServlet;
import com.icesoft.faces.webapp.http.servlet.PathDispatcher;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.util.IdGenerator;
import com.icesoft.util.MonitorRunner;
import com.icesoft.util.SeamUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MainServlet
extends HttpServlet {
    private PathDispatcher dispatcher = new PathDispatcher();
    private String contextPath;
    private ServletContext context;
    private MonitorRunner monitorRunner;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
        try {
            final ServletContextConfiguration configuration = new ServletContextConfiguration("com.icesoft.faces", this.context);
            final IdGenerator idGenerator = new IdGenerator(this.context.getResource("/WEB-INF/web.xml").getPath());
            final MimeTypeMatcher mimeTypeMatcher = new MimeTypeMatcher(){

                public String mimeTypeFor(String extension) {
                    return MainServlet.this.context.getMimeType(extension);
                }
            };
            FileLocator localFileLocator = new FileLocator(){

                public File locate(String path) {
                    URI contextURI = URI.create(MainServlet.this.contextPath);
                    URI pathURI = URI.create(path);
                    String result = contextURI.relativize(pathURI).getPath();
                    String fileLocation = MainServlet.this.context.getRealPath(result);
                    return new File(fileLocation);
                }
            };
            this.monitorRunner = new MonitorRunner(configuration.getAttributeAsLong("monitorRunnerInterval", 10000L));
            RenderManager.setServletConfig(servletConfig);
            BasicAdaptingServlet resourceServer = new BasicAdaptingServlet(new ResourceServer(configuration, mimeTypeMatcher, localFileLocator));
            BasicAdaptingServlet sessionExpiredServer = new BasicAdaptingServlet(new SessionExpiredServer());
            SessionDispatcher sessionServer = new SessionDispatcher(sessionExpiredServer){

                protected PseudoServlet newServlet(HttpSession session, SessionDispatcher.Monitor sessionMonitor) {
                    return new MainSessionBoundServlet(session, sessionMonitor, idGenerator, mimeTypeMatcher, MainServlet.this.monitorRunner, configuration);
                }
            };
            if (SeamUtilities.isSpringEnvironment()) {
                this.dispatcher.dispatchOn("/spring/resources/", resourceServer);
            }
            this.dispatcher.dispatchOn(".*(\\.iface$|\\.jsf|\\.faces$|\\.jsp$|\\.jspx$|\\.html$|\\.xhtml$|\\.seam$|uploadHtml$|block\\/|/spring/)", sessionServer);
            this.dispatcher.dispatchOn(".*", resourceServer);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.contextPath = request.getContextPath();
        try {
            this.dispatcher.service(request, response);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.monitorRunner.stop();
        DisposeBeans.in(this.context);
        this.dispatcher.shutdown();
    }

    static {
        String headless = "java.awt.headless";
        if (null == System.getProperty("java.awt.headless")) {
            System.setProperty("java.awt.headless", "true");
        }
    }
}

