/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.ResourceLinker;
import com.icesoft.faces.webapp.http.common.MimeTypeMatcher;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.CompressingServer;
import com.icesoft.faces.webapp.http.common.standard.PathDispatcherServer;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.util.encoding.Base64;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;

public class ResourceDispatcher
implements Server {
    private static final ResourceLinker.Handler NOOPHandler = new ResourceLinker.Handler(){

        public void linkWith(ResourceLinker linker) {
        }
    };
    private PathDispatcherServer dispatcher = new PathDispatcherServer();
    private Server compressResource = new CompressingServer(this.dispatcher);
    private MimeTypeMatcher mimeTypeMatcher;
    private String prefix;
    private ArrayList registered = new ArrayList();
    private SessionDispatcher.Monitor monitor;

    public ResourceDispatcher(String prefix, MimeTypeMatcher mimeTypeMatcher, SessionDispatcher.Monitor monitor) {
        this.prefix = prefix;
        this.mimeTypeMatcher = mimeTypeMatcher;
        this.monitor = monitor;
    }

    public void service(Request request) throws Exception {
        this.compressResource.service(request);
    }

    public URI registerResource(String mimeType, Resource resource) {
        return this.registerResource(mimeType, resource, NOOPHandler);
    }

    public URI registerResource(String mimeType, Resource resource, ResourceLinker.Handler handler) {
        String name = this.prefix + ResourceDispatcher.encode(resource) + "/";
        if (!this.registered.contains(name)) {
            this.registered.add(name);
            this.dispatcher.dispatchOn(".*" + name.replaceAll("\\/", "\\/") + "$", new ResourceServer(mimeType, resource));
            if (handler != NOOPHandler) {
                handler.linkWith(new RelativeResourceLinker(name));
            }
        }
        return URI.create(name);
    }

    public URI registerNamedResource(String name, Resource resource) {
        return this.registerNamedResource(name, resource, NOOPHandler);
    }

    public URI registerNamedResource(String fileName, Resource resource, ResourceLinker.Handler handler) {
        String name = this.prefix + ResourceDispatcher.encode(resource) + "-" + fileName;
        if (!this.registered.contains(name)) {
            this.registered.add(name);
            String pathExpression = name.replaceAll("\\/", "\\/").replaceAll("\\.", "\\.");
            String type = this.mimeTypeMatcher.mimeTypeFor(fileName);
            this.dispatcher.dispatchOn(".*" + pathExpression + "$", new ResourceServer(type, resource));
            if (handler != NOOPHandler) {
                handler.linkWith(new RelativeResourceLinker(name));
            }
        }
        return URI.create(name);
    }

    public void shutdown() {
        this.compressResource.shutdown();
        this.registered.clear();
    }

    private static String encode(Resource resource) {
        return Base64.encode(String.valueOf(resource.calculateDigest().hashCode()));
    }

    private class RelativeResourceLinker
    implements ResourceLinker {
        private final String name;

        public RelativeResourceLinker(String name) {
            this.name = name;
        }

        public void registerRelativeResource(String path, Resource relativeResource) {
            String pathExpression = (this.name + path).replaceAll("\\/", "\\/").replaceAll("\\.", "\\.");
            String type = ResourceDispatcher.this.mimeTypeMatcher.mimeTypeFor(path);
            ResourceDispatcher.this.dispatcher.dispatchOn(".*" + pathExpression + "$", new ResourceServer(type, relativeResource));
        }
    }

    private class ResourceServer
    implements Server,
    ResponseHandler {
        private ResponseHandler notModified = new ResponseHandler(){

            public void respond(Response response) throws Exception {
                response.setStatus(304);
                response.setHeader("ETag", ResourceDispatcher.encode(ResourceServer.this.resource));
                response.setHeader("Date", new Date());
                response.setHeader("Last-Modified", ResourceServer.this.resource.lastModified());
                response.setHeader("Expires", ResourceDispatcher.this.monitor.expiresBy());
            }
        };
        private String mimeType;
        private final Resource resource;

        public ResourceServer(String mimeType, Resource resource) {
            this.mimeType = mimeType;
            this.resource = resource;
        }

        public void service(Request request) throws Exception {
            try {
                Date modifiedSince = request.getHeaderAsDate("If-Modified-Since");
                if (this.resource.lastModified().getTime() > modifiedSince.getTime() + 1000L) {
                    request.respondWith(this);
                } else {
                    request.respondWith(this.notModified);
                }
            }
            catch (Exception e) {
                request.respondWith(this);
            }
        }

        public void respond(Response response) throws Exception {
            response.setHeader("ETag", ResourceDispatcher.encode(this.resource));
            response.setHeader("Cache-Control", "public");
            response.setHeader("Content-Type", this.mimeType);
            response.setHeader("Last-Modified", this.resource.lastModified());
            response.setHeader("Expires", ResourceDispatcher.this.monitor.expiresBy());
            response.writeBodyFrom(this.resource.open());
        }

        public void shutdown() {
        }
    }
}

