/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.http.core.JsfLifecycleExecutor;
import com.icesoft.faces.webapp.http.core.SwfLifecycleExecutor;
import com.icesoft.faces.webapp.http.servlet.SpringWebFlowInstantiationServlet;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.executor.FlowExecutor;

public abstract class LifecycleExecutor {
    private static Log log = LogFactory.getLog((Class)LifecycleExecutor.class);
    private static LifecycleExecutor jsfExecutor = null;
    private static LifecycleExecutor swfExecutor = null;

    public static LifecycleExecutor getLifecycleExecutor(FacesContext context) {
        LifecycleExecutor.init();
        if (null != swfExecutor && !LifecycleExecutor.isExtensionMapped(context)) {
            return swfExecutor;
        }
        return jsfExecutor;
    }

    public abstract void apply(FacesContext var1);

    private static void init() {
        FlowExecutor flowExecutor;
        block4: {
            if (null != jsfExecutor) {
                return;
            }
            flowExecutor = null;
            try {
                flowExecutor = SpringWebFlowInstantiationServlet.getFlowExecutor();
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"SpringWebFlow unavailable ");
            }
        }
        if (null != flowExecutor) {
            swfExecutor = new SwfLifecycleExecutor();
        }
        jsfExecutor = new JsfLifecycleExecutor();
    }

    static boolean isExtensionMapped(FacesContext facesContext) {
        int dotIndex;
        String requestURI;
        int slashIndex;
        Object request = facesContext.getExternalContext().getRequest();
        return request instanceof HttpServletRequest && (slashIndex = (requestURI = ((HttpServletRequest)request).getRequestURI()).lastIndexOf("/")) < (dotIndex = requestURI.lastIndexOf("."));
    }
}

