/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.context.JAXPSerializer;
import com.icesoft.faces.util.DOMUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NormalModeSerializer
implements DOMSerializer {
    private static final Log log = LogFactory.getLog((Class)NormalModeSerializer.class);
    private BridgeFacesContext context;
    private Writer writer;

    public NormalModeSerializer(BridgeFacesContext context, Writer writer) {
        this.context = context;
        this.writer = writer;
    }

    public void serialize(Document document) throws IOException {
        if (this.context.isContentIncluded()) {
            Node body;
            if (log.isDebugEnabled()) {
                log.debug((Object)"treating request as a fragment");
            }
            if (null != (body = DOMUtils.getChildByNodeName(document.getDocumentElement(), "body"))) {
                this.writer.write("<div>\n");
                this.writer.write(DOMUtils.childrenToString(body));
                this.writer.write("</div>\n");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"treating request as a whole page (not a fragment)");
            }
            Map requestMap = this.context.getExternalContext().getRequestMap();
            String publicID = (String)requestMap.get("com.icesoft.doctype.public");
            String systemID = (String)requestMap.get("com.icesoft.doctype.system");
            String root = (String)requestMap.get("com.icesoft.doctype.root");
            String output = (String)requestMap.get("com.icesoft.doctype.output");
            boolean prettyPrinting = Boolean.valueOf((String)requestMap.get("com.icesoft.doctype.prettyprinting"));
            if (output == null || "html".equals(output) && !prettyPrinting) {
                if (publicID != null && systemID != null && root != null) {
                    this.writer.write(DOMUtils.DocumentTypetoString(publicID, systemID, root));
                }
                this.writer.write(DOMUtils.DOMtoString(document));
            } else {
                JAXPSerializer serializer = new JAXPSerializer(this.writer, publicID, systemID);
                if ("xml".equals(output)) {
                    serializer.outputAsXML();
                } else {
                    serializer.outputAsHTML();
                }
                if (prettyPrinting) {
                    serializer.printPretty();
                }
                serializer.serialize(document);
            }
        }
        this.writer.flush();
    }
}

