/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputmedia;

import com.icesoft.faces.component.outputmedia.OutputMedia;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.util.CoreUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OutputMediaRenderer
extends DomBasicRenderer {
    private static Map players = new HashMap();

    public OutputMediaRenderer() {
        Properties props = new Properties();
        props.setProperty("classid", "clsid:22D6f312-B0F6-11D0-94AB-0080C74C7E95");
        props.setProperty("codebase", "http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=6,4,7,1112");
        props.setProperty("pluginspage", "http://www.microsoft.com/windows/windowsmedia/download/AllDownloads.aspx");
        props.setProperty("sourceParamName", "filename");
        players.put("windows", props);
        props = new Properties();
        props.setProperty("classid", "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000");
        props.setProperty("codebase", "http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0");
        props.setProperty("pluginspage", "http://www.macromedia.com/go/getflashplayer");
        props.setProperty("sourceParamName", "movie");
        players.put("flash", props);
        props = new Properties();
        props.setProperty("classid", "clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B");
        props.setProperty("codebase", "http://www.apple.com/qtactivex/qtplugin.cab");
        props.setProperty("pluginspage", "http://www.apple.com/quicktime/download");
        props.setProperty("sourceParamName", "src");
        players.put("quicktime", props);
        props = new Properties();
        props.setProperty("classid", "clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA");
        props.setProperty("codebase", "http://www.real.com");
        props.setProperty("pluginspage", "http://www.real.com");
        props.setProperty("sourceParamName", "src");
        players.put("real", props);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element object;
        this.validateParameters(facesContext, uiComponent, null);
        OutputMedia mediaComponent = (OutputMedia)uiComponent;
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        if (domContext.isInitialized()) {
            DOMContext.removeChildren((Node)domContext.getRootNode());
            object = (Element)domContext.getRootNode();
        } else {
            object = domContext.createRootElement("object");
        }
        String idAndName = mediaComponent.getClientId(facesContext);
        String sourceURL = mediaComponent.getSource();
        if (sourceURL != null) {
            sourceURL = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)sourceURL);
        }
        String classid = null;
        String codebase = mediaComponent.getCodebase();
        String pluginspage = null;
        String sourceParamName = null;
        Properties playerProps = (Properties)players.get(mediaComponent.getPlayer());
        if (playerProps != null) {
            classid = playerProps.getProperty("classid");
            if (codebase == null) {
                codebase = playerProps.getProperty("codebase");
            }
            pluginspage = playerProps.getProperty("pluginspage");
            sourceParamName = playerProps.getProperty("sourceParamName");
        }
        this.setElementAttr(object, "classid", classid);
        this.setElementAttr(object, "codebase", codebase);
        this.setElementAttr(object, "standby", (UIComponent)mediaComponent, "standbyText");
        this.setElementAttr(object, "id", idAndName);
        this.setElementAttr(object, "name", idAndName);
        this.setElementAttr(object, "style", (UIComponent)mediaComponent, "style");
        this.setElementAttr(object, "class", (UIComponent)mediaComponent, "styleClass");
        this.setElementAttr(object, "type", (UIComponent)mediaComponent, "mimeType");
        Element embed = domContext.createElement("embed");
        this.setElementAttr(embed, "pluginspage", pluginspage);
        this.setElementAttr(embed, "src", sourceURL);
        this.setElementAttr(embed, "id", idAndName);
        this.setElementAttr(embed, "name", idAndName);
        this.setElementAttr(embed, "style", (UIComponent)mediaComponent, "style");
        this.setElementAttr(embed, "class", (UIComponent)mediaComponent, "styleClass");
        this.setElementAttr(embed, "type", (UIComponent)mediaComponent, "mimeType");
        this.appendParamElement(sourceParamName, sourceURL, object, domContext);
        List children = mediaComponent.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Object component = children.get(i);
            if (!(component instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)component;
            String paramName = parameter.getName();
            this.appendParamElement(paramName, parameter.getValue().toString(), object, domContext);
            if (paramName == null || embed.hasAttribute(paramName)) continue;
            this.setElementAttr(embed, paramName, (UIComponent)parameter, "value");
        }
        object.appendChild(embed);
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    private void setElementAttr(Element element, String elementAttrName, UIComponent component, String componentAttrName) {
        Object attrValue = component.getAttributes().get(componentAttrName);
        if (attrValue != null) {
            element.setAttribute(elementAttrName, attrValue.toString());
        }
    }

    private void setElementAttr(Element element, String elementAttrName, String attrValue) {
        if (attrValue != null) {
            element.setAttribute(elementAttrName, attrValue);
        }
    }

    private void appendParamElement(String paramName, String paramValue, Element element, DOMContext domContext) {
        if (paramName == null || paramValue == null) {
            return;
        }
        Element param = domContext.createElement("param");
        param.setAttribute("name", paramName);
        param.setAttribute("value", paramValue);
        element.appendChild(param);
    }
}

