/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.inputfile.InputFile;
import com.icesoft.faces.component.inputfile.InputFileProgressEvent;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.utils.MessageUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.commons.fileupload.FileUploadBase;

public class InputFileRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Throwable uploadException;
        String id = component.getClientId(context);
        InputFile c = (InputFile)component;
        BridgeFacesContext facesContext = (BridgeFacesContext)context;
        ResponseWriter writer = context.getResponseWriter();
        StringWriter iframeContentWriter = new StringWriter();
        c.renderIFrame(iframeContentWriter, facesContext);
        String frameName = id + ":uploadFrame";
        String pseudoURL = "javascript: document.write('" + iframeContentWriter.toString().replaceAll("\"", "%22") + "'); document.close();";
        writer.startElement("iframe", (UIComponent)c);
        writer.writeAttribute("src", (Object)pseudoURL, null);
        writer.writeAttribute("id", (Object)frameName, null);
        writer.writeAttribute("name", (Object)frameName, null);
        writer.writeAttribute("class", (Object)c.getStyleClass(), null);
        writer.writeAttribute("style", (Object)c.getStyle(), null);
        writer.writeAttribute("width", (Object)(c.getWidth() + "px"), null);
        writer.writeAttribute("height", (Object)(c.getHeight() + "px"), null);
        writer.writeAttribute("title", (Object)"Input File Frame", null);
        writer.writeAttribute("frameborder", (Object)"0", null);
        writer.writeAttribute("marginwidth", (Object)"0", null);
        writer.writeAttribute("marginheight", (Object)"0", null);
        writer.writeAttribute("scrolling", (Object)"no", null);
        writer.writeAttribute("allowtransparency", (Object)"true", null);
        writer.endElement("iframe");
        String submitOnUpload = c.getValidatedSubmitOnUpload();
        if (!submitOnUpload.equals("none")) {
            boolean preUpload = submitOnUpload.equals("preUpload") || submitOnUpload.equals("preAndPostUpload");
            boolean postUpload = submitOnUpload.equals("postUpload") || submitOnUpload.equals("preAndPostUpload");
            writer.startElement("script", (UIComponent)c);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeAttribute("id", (Object)id, null);
            writer.writeText((Object)("var register = function() {var frame = document.getElementById('" + frameName + "').contentWindow;" + "var submit = function() { " + "if(arguments.length == 1 && arguments[0] == 1) { " + (postUpload ? "Ice.InputFileIdPostUpload = '" + id + "'; Ice.InputFileIdPreUpload = null;" : "return;") + " } " + "else { " + (preUpload ? "Ice.InputFileIdPreUpload = '" + id + "'; Ice.InputFileIdPostUpload = null;" : "return;") + " } try { '" + id + "'.asExtendedElement().form().submit(); } catch (e) { logger.warn('Form not available', e); } finally { Ice.InputFileIdPreUpload = null; Ice.InputFileIdPostUpload = null; } };" + "frame.document.getElementsByTagName('form')[0].onsubmit = submit;" + "var uploadEnd = function() { submit(1); setTimeout(register, 200); };" + "if (frame.attachEvent) { frame.attachEvent('onunload', uploadEnd); } else { frame.onunload = uploadEnd; } };" + "setTimeout(register, 0);"), null);
            writer.endElement("script");
        }
        if ((uploadException = c.getUploadException()) != null) {
            try {
                throw uploadException;
            }
            catch (FileUploadBase.FileSizeLimitExceededException e) {
                context.addMessage(c.getClientId(context), MessageUtils.getMessage(context, "com.icesoft.faces.component.inputfile.SIZE_LIMIT_EXCEEDED"));
            }
            catch (FileUploadBase.UnknownSizeException e) {
                context.addMessage(c.getClientId(context), MessageUtils.getMessage(context, "com.icesoft.faces.component.inputfile.UNKNOWN_SIZE"));
            }
            catch (FileUploadBase.InvalidContentTypeException e) {
                File file;
                String fileName = c.getFileInfo().getFileName();
                if (fileName == null && (file = c.getFile()) != null) {
                    fileName = file.getName();
                }
                if (fileName == null) {
                    fileName = "";
                }
                context.addMessage(c.getClientId(context), MessageUtils.getMessage(context, "com.icesoft.faces.component.inputfile.INVALID_FILE", new Object[]{fileName}));
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        InputFile inputFile = (InputFile)component;
        inputFile.setPreUpload(false);
        inputFile.setPostUpload(false);
        Map parameter = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(facesContext);
        String preUpload = (String)parameter.get("ice.inputFile.preUpload");
        String postUpload = (String)parameter.get("ice.inputFile.postUpload");
        if (preUpload != null && preUpload.length() > 0 && preUpload.equals(clientId)) {
            inputFile.setPreUpload(true);
            inputFile.queueEvent(new InputFileProgressEvent((UIComponent)inputFile));
        }
        if (postUpload != null && postUpload.length() > 0 && postUpload.equals(clientId)) {
            inputFile.setPostUpload(true);
            inputFile.queueEvent(new InputFileProgressEvent((UIComponent)inputFile));
        }
    }
}

