/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.registry.basic;

import java.util.Map;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntryAlreadyRegisteredException;
import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.logging.Logger;
import org.jboss.util.CollectionsFactory;

public class BasicKernelRegistryFactory
implements KernelRegistryPlugin {
    private static final Logger log = Logger.getLogger((Class)BasicKernelRegistryFactory.class);
    protected Map entries = CollectionsFactory.createConcurrentReaderMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEntry(Object object, KernelRegistryEntry kernelRegistryEntry) {
        if (object == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (kernelRegistryEntry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        boolean bl = log.isTraceEnabled();
        Map map = this.entries;
        synchronized (map) {
            if (this.entries.containsKey(object)) {
                throw new KernelRegistryEntryAlreadyRegisteredException("Already registered: " + object);
            }
            this.entries.put(object, kernelRegistryEntry);
            kernelRegistryEntry.setName(object);
        }
        if (bl) {
            log.trace((Object)("Registered object: '" + kernelRegistryEntry + "' with name '" + object + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelRegistryEntry unregisterEntry(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null name");
        }
        boolean bl = log.isTraceEnabled();
        KernelRegistryEntry kernelRegistryEntry = null;
        Map map = this.entries;
        synchronized (map) {
            kernelRegistryEntry = (KernelRegistryEntry)this.entries.remove(object);
            if (kernelRegistryEntry == null) {
                throw new KernelRegistryEntryNotFoundException("Not found: " + object);
            }
        }
        if (bl) {
            log.trace((Object)("Unregistered name: '" + object + "'"));
        }
        return kernelRegistryEntry;
    }

    public KernelRegistryEntry getEntry(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null name");
        }
        return (KernelRegistryEntry)this.entries.get(object);
    }
}

