/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap.basic;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.AbstractKernelInitializer;
import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;

public class BasicKernelInitializer
extends AbstractKernelInitializer {
    public void initKernel(Kernel kernel) throws Throwable {
        KernelRegistry kernelRegistry = this.createKernelRegistry(kernel);
        if (this.trace) {
            this.log.trace((Object)("Using Registry: " + kernelRegistry));
        }
        kernelRegistry.setKernel(kernel);
        kernel.setRegistry(kernelRegistry);
        KernelEventManager kernelEventManager = this.createKernelEventManager(kernel);
        if (this.trace) {
            this.log.trace((Object)("Using EventManager: " + kernelEventManager));
        }
        kernelEventManager.setKernel(kernel);
        kernel.setEventManager(kernelEventManager);
        KernelBus kernelBus = this.createKernelBus(kernel);
        if (this.trace) {
            this.log.trace((Object)("Using Bus: " + kernelBus));
        }
        kernelBus.setKernel(kernel);
        kernel.setBus(kernelBus);
        KernelConfigurator kernelConfigurator = this.createKernelConfigurator(kernel);
        if (this.trace) {
            this.log.trace((Object)("Using Configurator: " + kernelConfigurator));
        }
        kernelConfigurator.setKernel(kernel);
        kernel.setConfigurator(kernelConfigurator);
        KernelController kernelController = this.createKernelController(kernel);
        if (this.trace) {
            this.log.trace((Object)("Using Controller: " + kernelController));
        }
        kernelController.setKernel(kernel);
        kernel.setController(kernelController);
        this.register(kernel, "jboss.kernel:service=KernelConfig", (Object)kernel.getConfig());
        this.register(kernel, "jboss.kernel:service=KernelInit", (Object)this);
        this.register(kernel, "jboss.kernel:service=Kernel", (Object)kernel);
        this.register(kernel, "jboss.kernel:service=KernelRegistry", (Object)kernelRegistry);
        this.register(kernel, "jboss.kernel:service=KernelEventManager", (Object)kernelEventManager);
        this.register(kernel, "jboss.kernel:service=KernelBus", (Object)kernelBus);
        this.register(kernel, "jboss.kernel:service=KernelConfigurator", (Object)kernelConfigurator);
        this.register(kernel, "jboss.kernel:service=KernelController", (Object)kernelController);
    }

    protected KernelBus createKernelBus(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelBus();
    }

    protected KernelConfigurator createKernelConfigurator(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelConfigurator();
    }

    protected KernelController createKernelController(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelController();
    }

    protected KernelEventManager createKernelEventManager(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelEventManager();
    }

    protected KernelRegistry createKernelRegistry(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelRegistry();
    }

    protected void register(Kernel kernel, String string, Object object) throws Throwable {
        this.register(kernel, this.getName(string), object);
    }

    protected void register(Kernel kernel, Object object, Object object2) throws Throwable {
        KernelRegistryEntry kernelRegistryEntry = this.createKernelRegistryEntry(kernel, object2);
        KernelRegistry kernelRegistry = kernel.getRegistry();
        kernelRegistry.registerEntry(object, kernelRegistryEntry);
    }

    protected Object getName(String string) throws Throwable {
        return string;
    }

    protected KernelRegistryEntry createKernelRegistryEntry(Kernel kernel, Object object) throws Throwable {
        return new AbstractKernelRegistryEntry(object);
    }
}

