/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.realm.JAASRealm;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAASCallbackHandler
implements CallbackHandler {
    private static Log log = LogFactory.getLog(JAASCallbackHandler.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.realm");
    protected String password = null;
    protected JAASRealm realm = null;
    protected String username = null;

    public JAASCallbackHandler(JAASRealm realm, String username, String password) {
        this.realm = realm;
        this.username = username;
        this.password = realm.hasMessageDigest() ? realm.digest(password) : password;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                if (this.realm.getContainer().getLogger().isTraceEnabled()) {
                    this.realm.getContainer().getLogger().trace((Object)sm.getString("jaasCallback.username", this.username));
                }
                ((NameCallback)callbacks[i]).setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                char[] passwordcontents = this.password != null ? this.password.toCharArray() : new char[]{};
                ((PasswordCallback)callbacks[i]).setPassword(passwordcontents);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

