/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.uuidgen;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.Loader;
import org.apache.juddi.uuidgen.UUIDGen;

public abstract class UUIDGenFactory {
    private static Log log = LogFactory.getLog((Class)UUIDGenFactory.class);
    private static final String IMPL_KEY = "juddi.uuidgen";
    private static final String DEFAULT_IMPL = "org.apache.juddi.uuidgen.DefaultUUIDGen";
    private static UUIDGen uuidgen = null;

    public static UUIDGen getUUIDGen() {
        if (uuidgen == null) {
            uuidgen = UUIDGenFactory.createUUIDGen();
        }
        return uuidgen;
    }

    private static synchronized UUIDGen createUUIDGen() {
        if (uuidgen != null) {
            return uuidgen;
        }
        String className = Config.getStringProperty(IMPL_KEY, DEFAULT_IMPL);
        log.debug((Object)("UUIDGen Implementation = " + className));
        Class uuidgenClass = null;
        try {
            uuidgenClass = Loader.getClassForName(className);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The specified UUIDGen class '" + className + "' was not found in classpath."));
            log.error((Object)e);
        }
        try {
            uuidgen = (UUIDGen)uuidgenClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Exception while attempting to instantiate the implementation of UUIDGen: " + uuidgenClass.getName() + "\n" + e.getMessage()));
            log.error((Object)e);
        }
        return uuidgen;
    }

    public static void main(String[] args) {
        int max = 100;
        try {
            UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
            for (int i = 0; i < 100; ++i) {
                System.out.println(i + ":  " + uuidgen.uuidgen());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

