/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.uuidgen;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.uuidgen.UUIDGen;

public class SecureUUIDGen
implements UUIDGen {
    private static Log log = LogFactory.getLog((Class)SecureUUIDGen.class);
    private static final BigInteger COUNT_START = new BigInteger("-12219292800000");
    private static final int CLOCK_SEQUENCE = new Random().nextInt(16384);

    public String uuidgen() {
        return this.nextUUID();
    }

    public String[] uuidgen(int nmbr) {
        String[] uuids = new String[nmbr];
        for (int i = 0; i < uuids.length; ++i) {
            uuids[i] = this.nextUUID();
        }
        return uuids;
    }

    protected String nextUUID() {
        int i;
        String clockSeqLow;
        String clockSeqHiAndReserved;
        String timeHiAndVersion;
        String timeMid;
        int i2;
        int i3;
        BigInteger current = BigInteger.valueOf(System.currentTimeMillis());
        BigInteger countMillis = current.subtract(COUNT_START);
        BigInteger count = countMillis.multiply(BigInteger.valueOf(10000L));
        String bitString = count.toString(2);
        if (bitString.length() < 60) {
            int nbExtraZeros = 60 - bitString.length();
            String extraZeros = new String();
            for (i3 = 0; i3 < nbExtraZeros; ++i3) {
                extraZeros = extraZeros.concat("0");
            }
            bitString = extraZeros.concat(bitString);
        }
        byte[] bits = bitString.getBytes();
        byte[] time_low = new byte[32];
        for (i3 = 0; i3 < 32; ++i3) {
            time_low[i3] = bits[bits.length - i3 - 1];
        }
        byte[] time_mid = new byte[16];
        for (int i4 = 0; i4 < 16; ++i4) {
            time_mid[i4] = bits[bits.length - 32 - i4 - 1];
        }
        byte[] time_hi_and_version = new byte[16];
        for (int i5 = 0; i5 < 12; ++i5) {
            time_hi_and_version[i5] = bits[bits.length - 48 - i5 - 1];
        }
        time_hi_and_version[12] = new String("1").getBytes()[0];
        time_hi_and_version[13] = new String("0").getBytes()[0];
        time_hi_and_version[14] = new String("0").getBytes()[0];
        time_hi_and_version[15] = new String("0").getBytes()[0];
        BigInteger clockSequence = BigInteger.valueOf(CLOCK_SEQUENCE);
        String clockString = clockSequence.toString(2);
        if (clockString.length() < 14) {
            int nbExtraZeros = 14 - bitString.length();
            String extraZeros = new String();
            for (i2 = 0; i2 < nbExtraZeros; ++i2) {
                extraZeros = extraZeros.concat("0");
            }
            clockString = extraZeros.concat(bitString);
        }
        byte[] clock_bits = clockString.getBytes();
        byte[] clock_seq_low = new byte[8];
        for (i2 = 0; i2 < 8; ++i2) {
            clock_seq_low[i2] = clock_bits[clock_bits.length - i2 - 1];
        }
        byte[] clock_seq_hi_and_reserved = new byte[8];
        for (int i6 = 0; i6 < 6; ++i6) {
            clock_seq_hi_and_reserved[i6] = clock_bits[clock_bits.length - 8 - i6 - 1];
        }
        clock_seq_hi_and_reserved[6] = new String("0").getBytes()[0];
        clock_seq_hi_and_reserved[7] = new String("1").getBytes()[0];
        String timeLow = Long.toHexString(new BigInteger(new String(SecureUUIDGen.reverseArray(time_low)), 2).longValue());
        if (timeLow.length() < 8) {
            int nbExtraZeros = 8 - timeLow.length();
            String extraZeros = new String();
            for (int i7 = 0; i7 < nbExtraZeros; ++i7) {
                extraZeros = extraZeros.concat("0");
            }
            timeLow = extraZeros.concat(timeLow);
        }
        if ((timeMid = Long.toHexString(new BigInteger(new String(SecureUUIDGen.reverseArray(time_mid)), 2).longValue())).length() < 4) {
            int nbExtraZeros = 4 - timeMid.length();
            String extraZeros = new String();
            for (int i8 = 0; i8 < nbExtraZeros; ++i8) {
                extraZeros = extraZeros.concat("0");
            }
            timeMid = extraZeros.concat(timeMid);
        }
        if ((timeHiAndVersion = Long.toHexString(new BigInteger(new String(SecureUUIDGen.reverseArray(time_hi_and_version)), 2).longValue())).length() < 4) {
            int nbExtraZeros = 4 - timeHiAndVersion.length();
            String extraZeros = new String();
            for (int i9 = 0; i9 < nbExtraZeros; ++i9) {
                extraZeros = extraZeros.concat("0");
            }
            timeHiAndVersion = extraZeros.concat(timeHiAndVersion);
        }
        if ((clockSeqHiAndReserved = Long.toHexString(new BigInteger(new String(SecureUUIDGen.reverseArray(clock_seq_hi_and_reserved)), 2).longValue())).length() < 2) {
            int nbExtraZeros = 2 - clockSeqHiAndReserved.length();
            String extraZeros = new String();
            for (int i10 = 0; i10 < nbExtraZeros; ++i10) {
                extraZeros = extraZeros.concat("0");
            }
            clockSeqHiAndReserved = extraZeros.concat(clockSeqHiAndReserved);
        }
        if ((clockSeqLow = Long.toHexString(new BigInteger(new String(SecureUUIDGen.reverseArray(clock_seq_low)), 2).longValue())).length() < 2) {
            int nbExtraZeros = 2 - clockSeqLow.length();
            String extraZeros = new String();
            for (int i11 = 0; i11 < nbExtraZeros; ++i11) {
                extraZeros = extraZeros.concat("0");
            }
            clockSeqLow = extraZeros.concat(clockSeqLow);
        }
        Random secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (Exception e) {
            secureRandom = new Random();
        }
        long nodeValue = secureRandom.nextLong();
        nodeValue = Math.abs(nodeValue);
        while (nodeValue > 0x800000000000L) {
            nodeValue = secureRandom.nextLong();
            nodeValue = Math.abs(nodeValue);
        }
        BigInteger nodeInt = BigInteger.valueOf(nodeValue);
        String nodeString = nodeInt.toString(2);
        if (nodeString.length() < 47) {
            int nbExtraZeros = 47 - nodeString.length();
            String extraZeros = new String();
            for (i = 0; i < nbExtraZeros; ++i) {
                extraZeros = extraZeros.concat("0");
            }
            nodeString = extraZeros.concat(nodeString);
        }
        byte[] node_bits = nodeString.getBytes();
        byte[] node = new byte[48];
        for (i = 0; i < 47; ++i) {
            node[i] = node_bits[node_bits.length - i - 1];
        }
        node[47] = new String("1").getBytes()[0];
        String theNode = Long.toHexString(new BigInteger(new String(SecureUUIDGen.reverseArray(node)), 2).longValue());
        if (theNode.length() < 12) {
            int nbExtraZeros = 12 - theNode.length();
            String extraZeros = new String();
            for (int i12 = 0; i12 < nbExtraZeros; ++i12) {
                extraZeros = extraZeros.concat("0");
            }
            theNode = extraZeros.concat(theNode);
        }
        String result = timeLow + "-" + timeMid + "-" + timeHiAndVersion + "-" + clockSeqHiAndReserved + clockSeqLow + "-" + theNode;
        return result.toUpperCase();
    }

    private static byte[] reverseArray(byte[] bits) {
        byte[] result = new byte[bits.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bits[result.length - 1 - i];
        }
        return result;
    }

    public static void main(String[] args) {
        SecureUUIDGen generator = new SecureUUIDGen();
        long start = System.currentTimeMillis();
        for (int i = 1; i <= 100; ++i) {
            generator.uuidgen();
        }
        long end = System.currentTimeMillis();
        System.out.println("SecureUUIDGen: Generation of 100 UUID's took " + (end - start) + " milliseconds.");
    }
}

