/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.SaveBinding;
import org.apache.juddi.datatype.response.BindingDetail;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UserMismatchException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

public class SaveBindingFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)SaveBindingFunction.class);

    public SaveBindingFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        SaveBinding request = (SaveBinding)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector bindingVector = request.getBindingTemplateVector();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            BindingTemplate binding;
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            for (i = 0; i < bindingVector.size(); ++i) {
                int vectorSize;
                Vector keyedRefVector;
                binding = (BindingTemplate)bindingVector.elementAt(i);
                String serviceKey = binding.getServiceKey();
                String bindingKey = binding.getBindingKey();
                if (serviceKey == null || serviceKey.length() == 0 || !dataStore.isValidServiceKey(serviceKey)) {
                    throw new InvalidKeyPassedException("save_binding: serviceKey=" + serviceKey);
                }
                if (!dataStore.isServicePublisher(serviceKey, publisherID)) {
                    throw new UserMismatchException("save_binding: publisherID=" + publisherID + ", " + "serviceKey=" + serviceKey);
                }
                if (bindingKey != null && bindingKey.length() > 0 && !dataStore.isValidBindingKey(bindingKey)) {
                    throw new InvalidKeyPassedException("save_binding: bindingKey=" + bindingKey);
                }
                CategoryBag categoryBag = binding.getCategoryBag();
                if (categoryBag == null || (keyedRefVector = categoryBag.getKeyedReferenceVector()) == null || (vectorSize = keyedRefVector.size()) <= 0) continue;
                for (int j = 0; j < vectorSize; ++j) {
                    KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(j);
                    String key = keyedRef.getTModelKey();
                    if (key != null && key.trim().length() != 0) continue;
                    keyedRef.setTModelKey("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4");
                }
            }
            for (i = 0; i < bindingVector.size(); ++i) {
                binding = (BindingTemplate)bindingVector.elementAt(i);
                String bindingKey = binding.getBindingKey();
                if (bindingKey != null && bindingKey.length() > 0) {
                    dataStore.deleteBinding(bindingKey);
                } else {
                    binding.setBindingKey(uuidgen.uuidgen());
                }
                dataStore.saveBinding(binding);
            }
            dataStore.commit();
            BindingDetail detail = new BindingDetail();
            detail.setGeneric(generic);
            detail.setOperator(Config.getOperator());
            detail.setTruncated(false);
            detail.setBindingTemplateVector(bindingVector);
            BindingDetail bindingDetail = detail;
            return bindingDetail;
        }
        catch (InvalidKeyPassedException ikpex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ikpex);
            throw ikpex;
        }
        catch (UserMismatchException umex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)umex);
            throw umex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }
}

