/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.GetRegisteredInfo;
import org.apache.juddi.datatype.response.BusinessInfos;
import org.apache.juddi.datatype.response.RegisteredInfo;
import org.apache.juddi.datatype.response.TModelInfos;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetRegisteredInfoFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)GetRegisteredInfoFunction.class);

    public GetRegisteredInfoFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetRegisteredInfo request = (GetRegisteredInfo)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            int i;
            int rowCount;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            BusinessInfos businessInfos = new BusinessInfos();
            TModelInfos tModelInfos = new TModelInfos();
            Vector keyVector = null;
            Vector<RegistryObject> infoVector = null;
            keyVector = dataStore.findRegisteredBusinesses(publisherID);
            if (keyVector != null && keyVector.size() > 0) {
                rowCount = keyVector.size();
                infoVector = new Vector<RegistryObject>(rowCount);
                for (i = 0; i < rowCount; ++i) {
                    infoVector.addElement(dataStore.fetchBusinessInfo((String)keyVector.elementAt(i)));
                }
                businessInfos.setBusinessInfoVector(infoVector);
            }
            if ((keyVector = dataStore.findRegisteredTModels(publisherID)) != null && keyVector.size() > 0) {
                rowCount = keyVector.size();
                infoVector = new Vector(rowCount);
                for (i = 0; i < rowCount; ++i) {
                    infoVector.addElement(dataStore.fetchTModelInfo((String)keyVector.elementAt(i)));
                }
                tModelInfos.setTModelInfoVector(infoVector);
            }
            dataStore.commit();
            RegisteredInfo info = new RegisteredInfo();
            info.setGeneric(generic);
            info.setOperator(Config.getOperator());
            info.setBusinessInfos(businessInfos);
            info.setTModelInfos(tModelInfos);
            RegisteredInfo registeredInfo = info;
            return registeredInfo;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }
}

