/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.request.GetBusinessDetail;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetBusinessDetailFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)GetBusinessDetailFunction.class);

    public GetBusinessDetailFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetBusinessDetail request = (GetBusinessDetail)regObject;
        String generic = request.getGeneric();
        Vector businessKeyVector = request.getBusinessKeyVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            for (int i = 0; i < businessKeyVector.size(); ++i) {
                String businessKey = (String)businessKeyVector.elementAt(i);
                if (businessKey != null && businessKey.length() != 0 && dataStore.isValidBusinessKey(businessKey)) continue;
                throw new InvalidKeyPassedException("get_businessDetail: businessKey=" + businessKey);
            }
            Vector<BusinessEntity> businessVector = new Vector<BusinessEntity>();
            for (int i = 0; i < businessKeyVector.size(); ++i) {
                String businessKey = (String)businessKeyVector.elementAt(i);
                businessVector.addElement(dataStore.fetchBusiness(businessKey));
            }
            dataStore.commit();
            BusinessDetail detail = new BusinessDetail();
            detail.setGeneric(generic);
            detail.setOperator(Config.getOperator());
            detail.setBusinessEntityVector(businessVector);
            BusinessDetail businessDetail = detail;
            return businessDetail;
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)keyex.getMessage());
            throw keyex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            dataStore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }
}

