/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.request.GetBindingDetail;
import org.apache.juddi.datatype.response.BindingDetail;
import org.apache.juddi.error.InvalidKeyPassedException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetBindingDetailFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)GetBindingDetailFunction.class);

    public GetBindingDetailFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetBindingDetail request = (GetBindingDetail)regObject;
        String generic = request.getGeneric();
        Vector keyVector = request.getBindingKeyVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            dataStore.beginTrans();
            for (int i = 0; i < keyVector.size(); ++i) {
                String bindingKey = (String)keyVector.elementAt(i);
                if (bindingKey != null && bindingKey.length() != 0 && dataStore.isValidBindingKey(bindingKey)) continue;
                throw new InvalidKeyPassedException("get_bindingDetail: bindingKey=" + bindingKey);
            }
            Vector<BindingTemplate> bindingVector = new Vector<BindingTemplate>();
            for (int i = 0; i < keyVector.size(); ++i) {
                String key = (String)keyVector.elementAt(i);
                bindingVector.add(dataStore.fetchBinding(key));
            }
            dataStore.commit();
            BindingDetail detail = new BindingDetail();
            detail.setGeneric(generic);
            detail.setBindingTemplateVector(bindingVector);
            detail.setOperator(Config.getOperator());
            BindingDetail bindingDetail = detail;
            return bindingDetail;
        }
        catch (InvalidKeyPassedException keyex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)keyex.getMessage());
            throw keyex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }
}

