/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.request.FindBusiness;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.response.BusinessInfos;
import org.apache.juddi.datatype.response.BusinessList;
import org.apache.juddi.error.NameTooLongException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.TooManyOptionsException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class FindBusinessFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog((Class)FindBusinessFunction.class);

    public FindBusinessFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        int i;
        int vectorSize;
        Vector keyedRefVector;
        FindBusiness request = (FindBusiness)regObject;
        String generic = request.getGeneric();
        Vector nameVector = request.getNameVector();
        DiscoveryURLs discoveryURLs = request.getDiscoveryURLs();
        IdentifierBag identifierBag = request.getIdentifierBag();
        CategoryBag categoryBag = request.getCategoryBag();
        TModelBag tModelBag = request.getTModelBag();
        FindQualifiers qualifiers = request.getFindQualifiers();
        int maxRows = request.getMaxRows();
        if (!(nameVector != null && nameVector.size() != 0 || discoveryURLs != null && discoveryURLs.size() != 0 || identifierBag != null && identifierBag.size() != 0 || categoryBag != null && categoryBag.size() != 0 || tModelBag != null && tModelBag.size() != 0)) {
            BusinessList list = new BusinessList();
            list.setGeneric(generic);
            list.setBusinessInfos(new BusinessInfos());
            list.setOperator(Config.getOperator());
            list.setTruncated(false);
            return list;
        }
        if (categoryBag != null && (keyedRefVector = categoryBag.getKeyedReferenceVector()) != null && (vectorSize = keyedRefVector.size()) > 0) {
            for (i = 0; i < vectorSize; ++i) {
                KeyedReference keyedRef = (KeyedReference)keyedRefVector.elementAt(i);
                String key = keyedRef.getTModelKey();
                if (key != null && key.trim().length() != 0) continue;
                keyedRef.setTModelKey("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4");
            }
        }
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            Vector qVector;
            dataStore.beginTrans();
            if (nameVector != null) {
                int maxNames = Config.getMaxNameElementsAllowed();
                if (nameVector != null && nameVector.size() > maxNames) {
                    throw new TooManyOptionsException("find_business: names=" + nameVector.size() + ", " + "maxNames=" + maxNames);
                }
                int maxNameLength = Config.getMaxNameLengthAllowed();
                for (int i2 = 0; i2 < nameVector.size(); ++i2) {
                    String name = ((Name)nameVector.elementAt(i2)).getValue();
                    if (name.length() <= maxNameLength) continue;
                    throw new NameTooLongException("find_business: name=" + name + ", " + "length=" + name.length() + ", " + "maxNameLength=" + maxNameLength);
                }
            }
            if (qualifiers != null && (qVector = qualifiers.getFindQualifierVector()) != null && qVector.size() > 0) {
                for (i = 0; i < qVector.size(); ++i) {
                    FindQualifier qualifier = (FindQualifier)qVector.elementAt(i);
                    String qValue = qualifier.getValue();
                    if (qValue.equals("exactNameMatch") || qValue.equals("caseSensitiveMatch") || qValue.equals("orAllKeys") || qValue.equals("orLikeKeys") || qValue.equals("andAllKeys") || qValue.equals("sortByNameAsc") || qValue.equals("sortByNameDesc") || qValue.equals("sortByDateAsc") || qValue.equals("sortByDateDesc") || qValue.equals("serviceSubset") || qValue.equals("combineCategoryBags")) continue;
                    throw new UnsupportedException("find_business: findQualifier=" + qValue);
                }
            }
            Vector<BusinessInfo> infoVector = null;
            boolean truncatedResults = false;
            Vector keyVector = dataStore.findBusiness(nameVector, discoveryURLs, identifierBag, categoryBag, tModelBag, qualifiers);
            if (keyVector != null && keyVector.size() > 0) {
                int rowCount = keyVector.size();
                if (maxRows > 0 && maxRows < rowCount) {
                    rowCount = maxRows;
                    truncatedResults = true;
                }
                infoVector = new Vector<BusinessInfo>(rowCount);
                for (int i3 = 0; i3 < rowCount; ++i3) {
                    infoVector.addElement(dataStore.fetchBusinessInfo((String)keyVector.elementAt(i3)));
                }
            }
            dataStore.commit();
            BusinessInfos infos = new BusinessInfos();
            infos.setBusinessInfoVector(infoVector);
            BusinessList list = new BusinessList();
            list.setBusinessInfos(infos);
            list.setGeneric(generic);
            list.setOperator(Config.getOperator());
            list.setTruncated(truncatedResults);
            BusinessList businessList = list;
            return businessList;
        }
        catch (TooManyOptionsException tmoex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)tmoex.getMessage());
            throw tmoex;
        }
        catch (NameTooLongException ntlex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)ntlex.getMessage());
            throw ntlex;
        }
        catch (UnsupportedException suppex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info((Object)suppex.getMessage());
            throw suppex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error((Object)ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            Vector<Name> nameVector = new Vector<Name>(5);
            nameVector.addElement(new Name("InflexionPoint"));
            nameVector.addElement(new Name("SteveViens.com"));
            nameVector.addElement(new Name("Liberty Mutual"));
            nameVector.addElement(new Name("Bowstreet"));
            nameVector.addElement(new Name("CMGi"));
            Vector<FindQualifier> qualifierVector = new Vector<FindQualifier>(1);
            qualifierVector.add(new FindQualifier("exactNameMatch"));
            FindQualifiers qualifiers = new FindQualifiers();
            qualifiers.setFindQualifierVector(qualifierVector);
            Vector<KeyedReference> categoryVector = new Vector<KeyedReference>();
            categoryVector.addElement(new KeyedReference("name1", "value1"));
            categoryVector.addElement(new KeyedReference("name2", "value2"));
            categoryVector.addElement(new KeyedReference("name3", "value3"));
            CategoryBag categoryBag = new CategoryBag();
            categoryBag.setKeyedReferenceVector(categoryVector);
            Vector<KeyedReference> identifierVector = new Vector<KeyedReference>();
            identifierVector.addElement(new KeyedReference("name1", "value1"));
            identifierVector.addElement(new KeyedReference("name1", "value1"));
            identifierVector.addElement(new KeyedReference("name1", "value1"));
            IdentifierBag identifierBag = new IdentifierBag();
            identifierBag.setKeyedReferenceVector(identifierVector);
            Vector<String> tModelKeyVector = new Vector<String>();
            tModelKeyVector.addElement(new String("6240b6f0-d4dd-4091-851b-d59fedbd0491"));
            tModelKeyVector.addElement(new String("ee0a154b-43ed-47be-b24f-878ab2956a31"));
            TModelBag tModelBag = new TModelBag();
            tModelBag.setTModelKeyVector(tModelKeyVector);
            Vector<DiscoveryURL> discoveryURLVector = new Vector<DiscoveryURL>();
            discoveryURLVector.addElement(new DiscoveryURL());
            discoveryURLVector.addElement(new DiscoveryURL());
            discoveryURLVector.addElement(new DiscoveryURL());
            DiscoveryURLs discoveryURLs = new DiscoveryURLs();
            discoveryURLs.setDiscoveryURLVector(discoveryURLVector);
            FindBusiness request = new FindBusiness();
            request.setNameVector(nameVector);
            request.setMaxRows(10);
            request.setCategoryBag(categoryBag);
            request.setIdentifierBag(identifierBag);
            request.setTModelBag(tModelBag);
            request.setDiscoveryURLs(discoveryURLs);
            request.setFindQualifiers(qualifiers);
            BusinessList response = (BusinessList)new FindBusinessFunction(reg).execute(request);
            System.out.println(response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }
}

