/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.KeyedReference;

class FindRelatedBusinessQuery {
    private static Log log = LogFactory.getLog((Class)FindRelatedBusinessQuery.class);
    static String selectSQL;
    static String selectWithKeyedRefSQL;

    FindRelatedBusinessQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, Connection connection) throws SQLException {
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            statement.setString(2, businessKey.toString());
            log.debug((Object)("select from PUBLISHER_ASSERTION table:\n\n\t" + selectSQL + "\n\t FROM_KEY=" + businessKey + "\n\t TO_KEY=" + businessKey + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String fromKey = resultSet.getString(1);
                String toKey = resultSet.getString(2);
                if (!fromKey.equalsIgnoreCase(businessKey)) {
                    keysOut.addElement(fromKey);
                    continue;
                }
                if (toKey.equalsIgnoreCase(businessKey)) continue;
                keysOut.addElement(toKey);
            }
            Vector<String> vector = keysOut;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector selectWithKeyedRef(String businessKey, KeyedReference keyedRef, Connection connection) throws SQLException {
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectWithKeyedRefSQL);
            statement.setString(1, businessKey);
            statement.setString(2, businessKey);
            statement.setString(3, keyedRef.getTModelKey());
            statement.setString(4, keyedRef.getKeyName());
            statement.setString(5, keyedRef.getKeyValue());
            log.debug((Object)("select from PUBLISHER_ASSERTION table:\n\n\t" + selectWithKeyedRefSQL + "\n\t FROM_KEY=" + businessKey + "\n\t TO_KEY=" + businessKey + "\n\t TMODEL_KEY=" + keyedRef.getTModelKey() + "\n\t KEY_NAME=" + keyedRef.getKeyName() + "\n\t KEY_VALUE=" + keyedRef.getKeyValue() + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String fromKey = resultSet.getString(1);
                String toKey = resultSet.getString(2);
                if (!fromKey.equalsIgnoreCase(businessKey)) {
                    keysOut.addElement(fromKey);
                    continue;
                }
                if (toKey.equalsIgnoreCase(businessKey)) continue;
                keysOut.addElement(toKey);
            }
            if (keysOut.size() > 0) {
                log.info((Object)"select successful, at least one matching row was found");
            } else {
                log.info((Object)"select executed successfully but no matching rows were found");
            }
            Vector<String> vector = keysOut;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(300);
        sql.append("SELECT FROM_KEY,TO_KEY,TMODEL_KEY,KEY_NAME,KEY_VALUE ");
        sql.append("FROM PUBLISHER_ASSERTION ");
        sql.append("WHERE (FROM_KEY=? OR TO_KEY=?) ");
        sql.append("AND FROM_CHECK='true' ");
        sql.append("AND TO_CHECK='true'");
        selectSQL = sql.toString();
        sql = new StringBuffer(300);
        sql.append("SELECT FROM_KEY,TO_KEY,TMODEL_KEY,KEY_NAME,KEY_VALUE ");
        sql.append("FROM PUBLISHER_ASSERTION ");
        sql.append("WHERE (FROM_KEY=? OR TO_KEY=?) ");
        sql.append("AND TMODEL_KEY=? ");
        sql.append("AND KEY_NAME=? ");
        sql.append("AND KEY_VALUE=? ");
        sql.append("AND FROM_CHECK='true' ");
        sql.append("AND TO_CHECK='true'");
        selectWithKeyedRefSQL = sql.toString();
    }
}

