/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.Description;

class BusinessDescTable {
    private static Log log = LogFactory.getLog((Class)BusinessDescTable.class);
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;

    BusinessDescTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, Vector descList, Connection connection) throws SQLException {
        if (descList == null || descList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            int listSize = descList.size();
            for (int descID = 0; descID < listSize; ++descID) {
                Description desc = (Description)descList.elementAt(descID);
                statement.setInt(2, descID);
                statement.setString(3, desc.getLanguageCode());
                statement.setString(4, desc.getValue());
                log.debug((Object)("insert into BUSINESS_DESCR table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t BUSINESS_DESCR_ID=" + descID + "\n\t LANG_CODE=" + desc.getLanguageCode() + "\n\t DESCR=" + desc.getValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, Connection connection) throws SQLException {
        Vector<Description> descList = new Vector<Description>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("select from BUSINESS_DESCR table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            Description desc = null;
            while (resultSet.next()) {
                desc = new Description();
                desc.setLanguageCode(resultSet.getString(1));
                desc.setValue(resultSet.getString(2));
                descList.add(desc);
            }
            Vector<Description> vector = descList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delete from BUSINESS_DESCR table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO BUSINESS_DESCR (");
        sql.append("BUSINESS_KEY,");
        sql.append("BUSINESS_DESCR_ID,");
        sql.append("LANG_CODE,");
        sql.append("DESCR) ");
        sql.append("VALUES (?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("LANG_CODE,");
        sql.append("DESCR, ");
        sql.append("BUSINESS_DESCR_ID ");
        sql.append("FROM BUSINESS_DESCR ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("ORDER BY BUSINESS_DESCR_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM BUSINESS_DESCR ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

