/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.PartNotFound;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public abstract class AbstractGetval {
    private ConnectionSapDB connection;
    protected byte[] descriptor;
    protected StructuredMem streamBuffer;
    protected int itemsInBuffer;
    protected int itemSize;
    protected boolean atEnd;
    protected boolean firstChunk = true;
    protected long longPosition = 0L;
    protected long longSize = -1L;

    public AbstractGetval(ConnectionSapDB connectionSapDB, byte[] byArray, StructuredMem structuredMem, int n) {
        this.connection = connectionSapDB;
        this.atEnd = false;
        this.itemSize = n;
        this.setupStreamBuffer(byArray, structuredMem);
    }

    protected boolean nextChunk() throws StreamIOException {
        try {
            ReplyPacket replyPacket;
            this.firstChunk = false;
            byte by = this.descriptor[27];
            if (by == 2 || by == 1) {
                this.atEnd = true;
                return false;
            }
            RequestPacket requestPacket = this.connection.getRequestPacket();
            DataPart dataPart = requestPacket.initGetval(this.connection.getAutoCommit());
            dataPart.putInt1(0, 0);
            dataPart.putBytes(this.descriptor, 1);
            int n = 0x7FFFFFFE;
            dataPart.putInt4(n, 37);
            dataPart.addArg(1, 40);
            dataPart.close();
            try {
                replyPacket = this.connection.execute(requestPacket, this, false);
            }
            catch (SQLExceptionSapDB sQLExceptionSapDB) {
                throw new StreamIOException(sQLExceptionSapDB);
            }
            replyPacket.findPart(18);
            int n2 = replyPacket.getPartDataPos();
            this.descriptor = replyPacket.getDataBytes(n2, 41);
            this.setupStreamBuffer(this.descriptor, replyPacket.getPointer(n2));
            return true;
        }
        catch (SQLException sQLException) {
            throw new StreamIOException((SQLExceptionSapDB)sQLException);
        }
        catch (PartNotFound partNotFound) {
            throw new StreamIOException(new InternalJDBCError(MessageTranslator.translate("error.longdata.expected")));
        }
    }

    protected ReplyPacket executeGetval(byte[] byArray) throws SQLException {
        RequestPacket requestPacket = this.connection.getRequestPacket();
        DataPart dataPart = requestPacket.initGetval(this.connection.getAutoCommit());
        dataPart.putInt1(0, 0);
        dataPart.putBytes(byArray, 1);
        dataPart.putInt4(Integer.MAX_VALUE, 37);
        dataPart.addArg(1, 40);
        dataPart.close();
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, false);
        return replyPacket;
    }

    private void setupStreamBuffer(byte[] byArray, StructuredMem structuredMem) {
        StructuredBytes structuredBytes = new StructuredBytes(byArray);
        int n = ((StructuredMem)structuredBytes).getInt4(32) - 1;
        this.itemsInBuffer = ((StructuredMem)structuredBytes).getInt4(36) / this.itemSize;
        this.streamBuffer = structuredMem.getPointer(n);
        this.descriptor = byArray;
    }

    public long length() throws SQLException {
        long l;
        if (this.longSize > -1L) {
            return this.longSize;
        }
        boolean bl = false;
        byte by = this.descriptor[27];
        switch (by) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                if (!this.firstChunk) break;
                bl = true;
                break;
            }
        }
        if (bl) {
            StructuredBytes structuredBytes = new StructuredBytes(this.descriptor);
            l = ((StructuredMem)structuredBytes).getInt4(36);
        } else {
            l = this.longSizeRequest();
        }
        this.longSize = l / (long)this.itemSize;
        return this.longSize;
    }

    protected long longSizeRequest() throws SQLException {
        byte[] byArray = new byte[this.descriptor.length];
        System.arraycopy(this.descriptor, 0, byArray, 0, this.descriptor.length);
        byArray[27] = 6;
        ReplyPacket replyPacket = this.executeGetval(byArray);
        try {
            replyPacket.findPart(18);
        }
        catch (PartNotFound partNotFound) {
            throw new InternalJDBCError(MessageTranslator.translate("error.longdata.expected"));
        }
        int n = replyPacket.getPartDataPos();
        byte[] byArray2 = replyPacket.getDataBytes(n, 41);
        StructuredBytes structuredBytes = new StructuredBytes(byArray2);
        long l = structuredBytes.getInt4(20) - 1;
        return l;
    }

    abstract InputStream getAsciiStream() throws SQLException;

    abstract InputStream getBinaryStream() throws SQLException;

    abstract Reader getCharacterStream() throws SQLException;
}

