/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tuckey.web.filters.urlrewrite.Conf;
import org.tuckey.web.filters.urlrewrite.Status;
import org.tuckey.web.filters.urlrewrite.UrlRewriteWrappedResponse;
import org.tuckey.web.filters.urlrewrite.UrlRewriter;
import org.tuckey.web.filters.urlrewrite.utils.Log;
import org.tuckey.web.filters.urlrewrite.utils.NumberUtils;
import org.tuckey.web.filters.urlrewrite.utils.ServerNameMatcher;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public final class UrlRewriteFilter
implements Filter {
    private static Log log = Log.getLog(UrlRewriteFilter.class);
    public static final String VERSION = "3.0.3 build 6002";
    public static final String DEFAULT_WEB_CONF_PATH = "/WEB-INF/urlrewrite.xml";
    private UrlRewriter urlRewriter = null;
    private boolean confReloadCheckEnabled = false;
    private int confReloadCheckInterval = 0;
    private long confLastLoad = 0L;
    private Conf confLastLoaded = null;
    private long confReloadLastCheck = 30L;
    private String confPath;
    private boolean confReloadInProgress = false;
    private boolean statusEnabled = true;
    private String statusPath = "/rewrite-status";
    private ServerNameMatcher statusServerNameMatcher;
    private static final String DEFAULT_STATUS_ENABLED_ON_HOSTS = "localhost, local, 127.0.0.1";
    private ServletContext context = null;

    public void init(FilterConfig filterConfig) {
        log.debug("filter init called");
        if (filterConfig == null) {
            log.error("unable to init filter as filter config is null");
            return;
        }
        log.debug("init: calling destroy just in case we are being re-inited uncleanly");
        this.destroyActual();
        this.context = filterConfig.getServletContext();
        if (this.context == null) {
            log.error("unable to init as servlet context is null");
            return;
        }
        Log.setConfiguration(filterConfig);
        String confReloadCheckIntervalStr = filterConfig.getInitParameter("confReloadCheckInterval");
        String confPathStr = filterConfig.getInitParameter("confPath");
        String statusPathConf = filterConfig.getInitParameter("statusPath");
        String statusEnabledConf = filterConfig.getInitParameter("statusEnabled");
        String statusEnabledOnHosts = filterConfig.getInitParameter("statusEnabledOnHosts");
        if (!StringUtils.isBlank(confReloadCheckIntervalStr)) {
            this.confReloadCheckInterval = 1000 * NumberUtils.stringToInt(confReloadCheckIntervalStr);
            if (this.confReloadCheckInterval < 0) {
                this.confReloadCheckEnabled = false;
                log.info("conf reload check disabled");
            } else if (this.confReloadCheckInterval == 0) {
                this.confReloadCheckEnabled = true;
                log.info("conf reload check performed each request");
            } else {
                this.confReloadCheckEnabled = true;
                log.info("conf reload check set to " + this.confReloadCheckInterval / 1000 + "s");
            }
        } else {
            this.confReloadCheckEnabled = false;
        }
        this.confPath = !StringUtils.isBlank(confPathStr) ? StringUtils.trim(confPathStr) : DEFAULT_WEB_CONF_PATH;
        log.debug("confPath set to " + this.confPath);
        if (statusEnabledConf != null && !"".equals(statusEnabledConf)) {
            log.debug("statusEnabledConf set to " + statusEnabledConf);
            this.statusEnabled = "true".equals(statusEnabledConf.toLowerCase());
        }
        if (this.statusEnabled) {
            if (statusPathConf != null && !"".equals(statusPathConf)) {
                this.statusPath = statusPathConf.trim();
                log.info("status display enabled, path set to " + this.statusPath);
            }
        } else {
            log.info("status display disabled");
        }
        if (StringUtils.isBlank(statusEnabledOnHosts)) {
            statusEnabledOnHosts = DEFAULT_STATUS_ENABLED_ON_HOSTS;
        } else {
            log.debug("statusEnabledOnHosts set to " + statusEnabledOnHosts);
        }
        this.statusServerNameMatcher = new ServerNameMatcher(statusEnabledOnHosts);
        this.loadConf();
    }

    private void loadConf() {
        InputStream inputStream = this.context.getResourceAsStream(this.confPath);
        URL confUrl = null;
        try {
            confUrl = this.context.getResource(this.confPath);
        }
        catch (MalformedURLException e) {
            log.debug(e);
        }
        String confUrlStr = null;
        if (confUrl != null) {
            confUrlStr = confUrl.toString();
        }
        if (inputStream == null) {
            log.error("unable to find urlrewrite conf file at " + this.confPath);
            if (this.urlRewriter != null) {
                log.error("unloading existing conf");
                this.urlRewriter = null;
            }
        } else {
            Conf conf = new Conf(this.context, inputStream, this.confPath, confUrlStr);
            if (log.isDebugEnabled()) {
                if (conf.getRules() != null) {
                    log.debug("inited with " + conf.getRules().size() + " rules");
                }
                log.debug("conf is " + (conf.isOk() ? "ok" : "NOT ok"));
            }
            this.confLastLoaded = conf;
            if (conf.isOk()) {
                this.urlRewriter = new UrlRewriter(conf);
                log.info("loaded (conf ok)");
            } else {
                log.error("Conf failed to load");
                log.error("unloading existing conf");
                this.urlRewriter = null;
            }
        }
    }

    public void destroy() {
        log.info("destroy called");
        this.destroyActual();
    }

    public void destroyActual() {
        if (this.urlRewriter != null) {
            this.urlRewriter.destroy();
            this.urlRewriter = null;
        }
        this.context = null;
        this.confLastLoad = 0L;
        this.confPath = DEFAULT_WEB_CONF_PATH;
        this.confReloadCheckEnabled = false;
        this.confReloadCheckInterval = 0;
        this.confReloadInProgress = false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long now = System.currentTimeMillis();
        if (this.confReloadCheckEnabled && !this.confReloadInProgress && now - (long)this.confReloadCheckInterval > this.confReloadLastCheck) {
            this.confReloadInProgress = true;
            this.confReloadLastCheck = now;
            log.debug("starting conf reload check");
            long confFileCurrentTime = this.getConfFileLastModified();
            if (this.confLastLoad < confFileCurrentTime) {
                this.confLastLoad = System.currentTimeMillis();
                log.info("conf file modified since last load, reloading");
                this.loadConf();
            } else {
                log.debug("conf is not modified");
            }
            this.confReloadInProgress = false;
        }
        HttpServletRequest hsRequest = (HttpServletRequest)request;
        HttpServletResponse hsResponse = (HttpServletResponse)response;
        UrlRewriteWrappedResponse urlRewriteWrappedResponse = new UrlRewriteWrappedResponse(hsResponse, hsRequest, this.urlRewriter);
        if (this.statusEnabled && this.statusServerNameMatcher.isMatch(request.getServerName())) {
            String uri = hsRequest.getRequestURI();
            if (log.isDebugEnabled()) {
                log.debug("checking for status path on " + uri);
            }
            String contextPath = hsRequest.getContextPath();
            if (uri != null && uri.startsWith(contextPath + this.statusPath)) {
                this.showStatus(hsRequest, (ServletResponse)urlRewriteWrappedResponse);
                return;
            }
        }
        boolean requestRewritten = false;
        if (this.urlRewriter != null) {
            requestRewritten = this.urlRewriter.processRequest(hsRequest, (HttpServletResponse)urlRewriteWrappedResponse, chain);
        } else if (log.isDebugEnabled()) {
            log.debug("urlRewriter engine not loaded ignoring request (could be a conf file problem)");
        }
        if (!requestRewritten) {
            chain.doFilter((ServletRequest)hsRequest, (ServletResponse)urlRewriteWrappedResponse);
        }
    }

    private long getConfFileLastModified() {
        File confFile = new File(this.context.getRealPath(DEFAULT_WEB_CONF_PATH));
        return confFile.lastModified();
    }

    private void showStatus(HttpServletRequest request, ServletResponse response) throws IOException {
        log.debug("showing status");
        Status status = new Status(this.confLastLoaded, this);
        status.displayStatusInContainer(request);
        response.setContentLength(status.getBuffer().length());
        PrintWriter out = response.getWriter();
        out.write(status.getBuffer().toString());
        out.close();
    }

    public boolean isConfReloadCheckEnabled() {
        return this.confReloadCheckEnabled;
    }

    public int getConfReloadCheckInterval() {
        return this.confReloadCheckInterval / 1000;
    }

    public Date getConfReloadLastCheck() {
        return new Date(this.confReloadLastCheck);
    }

    public boolean isStatusEnabled() {
        return this.statusEnabled;
    }

    public String getStatusPath() {
        return this.statusPath;
    }

    public boolean isLoaded() {
        return this.urlRewriter != null;
    }
}

