/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblemFactory
implements IProblemFactory {
    public HashtableOfInt messageTemplates;
    private Locale locale;
    private static HashtableOfInt DEFAULT_LOCALE_TEMPLATES;
    private static final char[] DOUBLE_QUOTES;
    private static final char[] SINGLE_QUOTE;

    static {
        DOUBLE_QUOTES = "''".toCharArray();
        SINGLE_QUOTE = "'".toCharArray();
    }

    public DefaultProblemFactory() {
        this(Locale.getDefault());
    }

    public DefaultProblemFactory(Locale loc) {
        this.locale = loc;
        if (Locale.getDefault().equals(loc)) {
            if (DEFAULT_LOCALE_TEMPLATES == null) {
                DEFAULT_LOCALE_TEMPLATES = DefaultProblemFactory.loadMessageTemplates(loc);
            }
            this.messageTemplates = DEFAULT_LOCALE_TEMPLATES;
        } else {
            this.messageTemplates = DefaultProblemFactory.loadMessageTemplates(loc);
        }
    }

    public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber) {
        return new DefaultProblem(originatingFileName, this.getLocalizedMessage(problemId, messageArguments), problemId, problemArguments, severity, startPosition, endPosition, lineNumber);
    }

    private static final int keyFromID(int id) {
        return id + 1;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final String getLocalizedMessage(int id, String[] problemArguments) {
        StringBuffer output;
        block11: {
            String message = (String)this.messageTemplates.get(DefaultProblemFactory.keyFromID(id & 0xFFFFFF));
            if (message == null) {
                return "Unable to retrieve the error message for problem id: " + (id & 0xFFFFFF) + ". Check compiler resources.";
            }
            char[] messageWithNoDoubleQuotes = CharOperation.replace(message.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            if (problemArguments == null) {
                return new String(messageWithNoDoubleQuotes);
            }
            int length = messageWithNoDoubleQuotes.length;
            int start = 0;
            int end = length;
            output = null;
            if ((id & Integer.MIN_VALUE) != 0) {
                if (output == null) {
                    output = new StringBuffer(10 + length + problemArguments.length * 20);
                }
                output.append((String)this.messageTemplates.get(DefaultProblemFactory.keyFromID(514)));
            }
            while ((end = CharOperation.indexOf('{', messageWithNoDoubleQuotes, start)) > -1) {
                if (output == null) {
                    output = new StringBuffer(length + problemArguments.length * 20);
                }
                output.append(messageWithNoDoubleQuotes, start, end - start);
                start = CharOperation.indexOf('}', messageWithNoDoubleQuotes, end + 1);
                if (start > -1) {
                    int index = -1;
                    String argId = new String(messageWithNoDoubleQuotes, end + 1, start - end - 1);
                    try {
                        index = Integer.parseInt(argId);
                        output.append(problemArguments[index]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        output.append(messageWithNoDoubleQuotes, end + 1, start - end);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return "Cannot bind message for problem (id: " + (id & 0xFFFFFF) + ") \"" + message + "\" with arguments: {" + Util.toString(problemArguments) + "}";
                    }
                    ++start;
                    continue;
                }
                output.append(messageWithNoDoubleQuotes, end, length);
                break block11;
            }
            if (output == null) {
                return new String(messageWithNoDoubleQuotes);
            }
            output.append(messageWithNoDoubleQuotes, start, length - start);
        }
        return new String(output.toString());
    }

    public final String localizedMessage(CategorizedProblem problem) {
        return this.getLocalizedMessage(problem.getID(), problem.getArguments());
    }

    public static HashtableOfInt loadMessageTemplates(Locale loc) {
        ResourceBundle bundle = null;
        String bundleName = "org.eclipse.jdt.internal.compiler.problem.messages";
        try {
            bundle = ResourceBundle.getBundle(bundleName, loc);
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + loc);
            throw e;
        }
        HashtableOfInt templates = new HashtableOfInt(700);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            try {
                int messageID = Integer.parseInt(key);
                templates.put(DefaultProblemFactory.keyFromID(messageID), bundle.getString(key));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return templates;
    }
}

