/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.swing;

import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import de.hunsicker.jalopy.swing.AbstractSettingsPage;
import de.hunsicker.jalopy.swing.AddRemoveList;
import de.hunsicker.jalopy.swing.SettingsContainer;
import de.hunsicker.swing.util.SwingHelper;
import de.hunsicker.util.ChainingRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class EnvironmentSettingsPage
extends AbstractSettingsPage {
    private static Map _changes = new HashMap();
    private static final Object ACTION_ADD = new Object();
    private static final Object ACTION_REMOVE = new Object();
    private static final char DELIM_PAIR = '^';
    private static final String EMPTY_STRING = "".intern();
    private static Pattern _variablesPattern;
    private static final PatternMatcher _matcher;
    private AddRemoveList _variablesList;
    private JButton _addButton;
    private JButton _removeButton;
    private JTabbedPane _tabs;

    public EnvironmentSettingsPage() {
        this.initialize();
    }

    EnvironmentSettingsPage(SettingsContainer container) {
        super(container);
        this.initialize();
    }

    public void updateSettings() {
        DefaultListModel keysListModel = (DefaultListModel)this._variablesList.getModel();
        if (keysListModel.size() > 0) {
            Object[] items = new ListEntry[keysListModel.size()];
            keysListModel.copyInto(items);
            StringBuffer buf = new StringBuffer(100);
            int i = 0;
            while (i < items.length) {
                buf.append(((ListEntry)items[i]).variable);
                buf.append('^');
                buf.append(((ListEntry)items[i]).value);
                buf.append("|");
                ++i;
            }
            buf.deleteCharAt(buf.length() - 1);
            this.settings.put(ConventionKeys.ENVIRONMENT, buf.toString());
        } else {
            this.settings.put(ConventionKeys.ENVIRONMENT, EMPTY_STRING);
        }
        Environment env = Environment.getInstance();
        Iterator i = _changes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ListEntry e = (ListEntry)entry.getKey();
            Object action = entry.getValue();
            if (action == ACTION_REMOVE) {
                env.unset(e.variable);
                continue;
            }
            env.set(e.variable, e.value);
        }
        _changes.clear();
    }

    private JPanel createSystemPane() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        ArrayList<ListEntry> variables = new ArrayList<ListEntry>();
        Iterator<Map.Entry<Object, Object>> i = System.getProperties().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            variables.add(new ListEntry((String)entry.getKey(), (String)entry.getValue()));
        }
        Collections.sort(variables);
        EnvironmentList envList = new EnvironmentList(EMPTY_STRING, null, variables);
        JScrollPane envListScrollPane = new JScrollPane(envList);
        SwingHelper.setConstraints(c, 0, 0, 1, 1, 1.0, 1.0, 18, 1, c.insets, 0, 0);
        layout.setConstraints(envListScrollPane, c);
        panel.add(envListScrollPane);
        return panel;
    }

    private JPanel createUserPane() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        String variablesString = this.settings.get(ConventionKeys.ENVIRONMENT, ConventionDefaults.ENVIRONMENT);
        ArrayList<ListEntry> variables = Collections.EMPTY_LIST;
        if (variablesString != null && !variablesString.trim().equals(EMPTY_STRING)) {
            variables = new ArrayList<ListEntry>();
            StringTokenizer tokens = new StringTokenizer(variablesString, "|");
            while (tokens.hasMoreElements()) {
                String v = tokens.nextToken();
                int offset = v.indexOf(94);
                String variable = v.substring(0, offset);
                String value = v.substring(offset + 1);
                variables.add(new ListEntry(variable, value));
            }
        }
        this._variablesList = new EnvironmentList(this.bundle.getString("TLE_ADD_NEW_VARIABLE"), null, variables);
        JScrollPane keysScrollPane = new JScrollPane(this._variablesList);
        SwingHelper.setConstraints(c, 0, 0, 8, 8, 1.0, 1.0, 17, 1, c.insets, 0, 0);
        layout.setConstraints(keysScrollPane, c);
        panel.add(keysScrollPane);
        c.insets.bottom = 2;
        c.insets.top = 10;
        c.insets.left = 10;
        c.insets.right = 0;
        SwingHelper.setConstraints(c, 9, 1, 0, 1, 0.0, 0.0, 18, 2, c.insets, 0, 0);
        this._addButton = this._variablesList.getAddButton();
        layout.setConstraints(this._addButton, c);
        panel.add(this._addButton);
        c.insets.left = 10;
        c.insets.right = 0;
        c.insets.bottom = 0;
        c.insets.top = 0;
        SwingHelper.setConstraints(c, 9, 2, 0, 1, 0.0, 1.0, 18, 2, c.insets, 0, 0);
        this._removeButton = this._variablesList.getRemoveButton();
        this._removeButton.setEnabled(false);
        layout.setConstraints(this._removeButton, c);
        this._removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                _changes.put(EnvironmentSettingsPage.this._variablesList.getSelectedValue(), ACTION_REMOVE);
            }
        });
        panel.add(this._removeButton);
        return panel;
    }

    private void initialize() {
        this._tabs = new JTabbedPane();
        JPanel userPanel = this.createUserPane();
        this._tabs.add((Component)userPanel, this.bundle.getString("TAB_USER"));
        JPanel systemPane = this.createSystemPane();
        this._tabs.add((Component)systemPane, this.bundle.getString("TAB_SYSTEM"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)this._tabs, "Center");
    }

    static /* synthetic */ Pattern access$500() {
        return _variablesPattern;
    }

    static /* synthetic */ PatternMatcher access$600() {
        return _matcher;
    }

    static /* synthetic */ Object access$700() {
        return ACTION_ADD;
    }

    static {
        _matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            _variablesPattern = compiler.compile("[a-zA-Z_][a-zA-Z0-9_]*", 32768);
        }
        catch (MalformedPatternException ex) {
            throw new ChainingRuntimeException(ex);
        }
    }

    private static class ListEntry
    implements Comparable {
        public String value;
        public String variable;

        public ListEntry(String variable, String value) {
            this.variable = variable;
            this.value = value;
        }

        public int compareTo(Object o) {
            if (o instanceof ListEntry) {
                return this.variable.compareTo(((ListEntry)o).variable);
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof ListEntry) {
                return this.variable.equals(((ListEntry)o).variable);
            }
            return false;
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(30);
            buf.append(this.variable);
            buf.append(' ');
            buf.append('=');
            buf.append(' ');
            buf.append(this.value);
            return buf.toString();
        }
    }

    private class EnvironmentList
    extends AddRemoveList {
        public EnvironmentList(String title, String text, Collection data) {
            super(title, text, data);
        }

        protected JDialog getAddDialog(Frame owner) {
            return new AddDialog(owner, this.title, this.text);
        }

        protected JDialog getAddDialog(Dialog owner) {
            return new AddDialog(owner, this.title, this.text);
        }

        private class AddDialog
        extends JDialog {
            public AddDialog(Frame owner, String title, String text) {
                super(owner);
                this.initialize(title, text);
            }

            public AddDialog(Dialog owner, String title, String text) {
                super(owner);
                this.initialize(title, text);
            }

            private void initialize(String title, String text) {
                this.setTitle(title);
                this.setModal(true);
                this.setDefaultCloseOperation(2);
                Container contentPane = this.getContentPane();
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                contentPane.setLayout(layout);
                JLabel variableLabel = new JLabel(((EnvironmentList)EnvironmentList.this).EnvironmentSettingsPage.this.bundle.getString("LBL_VARIABLE"));
                c.insets.top = 10;
                c.insets.left = 5;
                c.insets.right = 5;
                SwingHelper.setConstraints(c, 0, 0, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
                layout.setConstraints(variableLabel, c);
                contentPane.add(variableLabel);
                JTextField variableTextField = new JTextField(20);
                variableLabel.setLabelFor(variableTextField);
                c.insets.top = 2;
                SwingHelper.setConstraints(c, 0, 1, 12, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
                layout.setConstraints(variableTextField, c);
                contentPane.add(variableTextField);
                JLabel valueLabel = new JLabel(((EnvironmentList)EnvironmentList.this).EnvironmentSettingsPage.this.bundle.getString("LBL_VALUE"));
                c.insets.top = 10;
                c.insets.left = 5;
                c.insets.right = 5;
                SwingHelper.setConstraints(c, 0, 2, 0, 1, 1.0, 0.0, 18, 2, c.insets, 0, 0);
                layout.setConstraints(valueLabel, c);
                contentPane.add(valueLabel);
                JTextField valueTextField = new JTextField(20);
                valueLabel.setLabelFor(valueTextField);
                c.insets.top = 2;
                SwingHelper.setConstraints(c, 0, 3, 12, 1, 1.0, 1.0, 18, 2, c.insets, 0, 0);
                layout.setConstraints(valueTextField, c);
                contentPane.add(valueTextField);
                JButton cancelButton = SwingHelper.createButton(((EnvironmentList)EnvironmentList.this).EnvironmentSettingsPage.this.bundle.getString("BTN_CANCEL"), false);
                cancelButton.addActionListener(new ActionListener(this){
                    private final /* synthetic */ AddDialog this$2;
                    {
                        this.this$2 = this$2;
                    }

                    public void actionPerformed(ActionEvent e) {
                        this.this$2.setVisible(false);
                        this.this$2.dispose();
                    }
                });
                JButton okButton = SwingHelper.createButton(((EnvironmentList)EnvironmentList.this).EnvironmentSettingsPage.this.bundle.getString("BTN_OK"), false);
                okButton.addActionListener(new ActionListener(this, variableTextField, valueTextField){
                    private final /* synthetic */ JTextField val$variableTextField;
                    private final /* synthetic */ JTextField val$valueTextField;
                    private final /* synthetic */ AddDialog this$2;
                    {
                        this.this$2 = this$2;
                        this.val$variableTextField = val$variableTextField;
                        this.val$valueTextField = val$valueTextField;
                    }

                    public void actionPerformed(ActionEvent e) {
                        String value;
                        String variable = this.val$variableTextField.getText().trim();
                        ListEntry entry = new ListEntry(variable, value = this.val$valueTextField.getText().trim());
                        if (AddDialog.access$400((AddDialog)this.this$2).listModel.contains(entry)) {
                            return;
                        }
                        if (!EnvironmentSettingsPage.access$600().matches(variable, EnvironmentSettingsPage.access$500())) {
                            Object[] args = new Object[]{variable, EnvironmentSettingsPage.access$500().getPattern()};
                            JOptionPane.showMessageDialog(this.this$2, MessageFormat.format(EnvironmentList.access$300((EnvironmentList)AddDialog.access$400((AddDialog)this.this$2)).bundle.getString("MSG_INVALID_VARIABLE"), args), EnvironmentList.access$300((EnvironmentList)AddDialog.access$400((AddDialog)this.this$2)).bundle.getString("TLE_INVALID_VARIABLE"), 0);
                            return;
                        }
                        AddDialog.access$400((AddDialog)this.this$2).listModel.add(0, entry);
                        AddDialog.access$400(this.this$2).setSelectedIndex(0);
                        this.this$2.dispose();
                        EnvironmentSettingsPage.access$200().put(entry, EnvironmentSettingsPage.access$700());
                    }
                });
                this.getRootPane().setDefaultButton(okButton);
                c.insets.top = 15;
                c.insets.bottom = 5;
                SwingHelper.setConstraints(c, 9, 4, 1, 1, 1.0, 0.0, 13, 0, c.insets, 0, 0);
                layout.setConstraints(okButton, c);
                contentPane.add(okButton);
                c.insets.left = 0;
                SwingHelper.setConstraints(c, 11, 4, 0, 1, 0.0, 0.0, 17, 0, c.insets, 0, 0);
                layout.setConstraints(cancelButton, c);
                contentPane.add(cancelButton);
            }

            static /* synthetic */ EnvironmentList access$400(AddDialog x0) {
                return x0.EnvironmentList.this;
            }
        }
    }
}

