/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class TryCatchFinallyPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new TryCatchFinallyPrinter();

    protected TryCatchFinallyPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        out.print("try", 105);
        this.printCommentsAfter(node, out);
        AST child = node.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 11: {
                    PrinterFactory.create(child).print(child, out);
                    break;
                }
                case 106: {
                    this.printCatch(child, out);
                    break;
                }
                case 107: {
                    this.printFinallyPart(child, out);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal type -- " + child);
                }
            }
            child = child.getNextSibling();
        }
        out.last = 8;
    }

    private boolean isEolCommentBefore(AST node) {
        block14: {
            switch (node.getType()) {
                case 106: {
                    JavaNode lcurly = ((JavaNode)node).getPreviousSibling();
                    AST child = lcurly.getFirstChild();
                    while (child != null) {
                        if (child.getNextSibling() == null) {
                            JavaNode rcurly = (JavaNode)child;
                            return rcurly.hasCommentsAfter();
                        }
                        child = child.getNextSibling();
                    }
                    break;
                }
                case 107: {
                    JavaNode previous = ((JavaNode)node).getPreviousSibling();
                    switch (previous.getType()) {
                        case 106: {
                            AST child = previous.getFirstChild().getNextSibling().getFirstChild();
                            while (child != null) {
                                if (child.getNextSibling() == null) {
                                    JavaNode rcurly = (JavaNode)child;
                                    return rcurly.hasCommentsAfter();
                                }
                                child = child.getNextSibling();
                            }
                            break block14;
                        }
                        case 105: {
                            AST child = previous.getFirstChild();
                            while (child != null) {
                                if (child.getNextSibling() == null) {
                                    JavaNode rcurly = (JavaNode)child;
                                    return rcurly.hasCommentsAfter();
                                }
                                child = child.getNextSibling();
                            }
                            break block0;
                        }
                    }
                }
            }
        }
        return false;
    }

    private void printCatch(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
        if (!this.isEolCommentBefore(node)) {
            out.print(out.getString(settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 153);
        }
        out.print("catch", 106);
        if (settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true)) {
            out.print(" ", 106);
        }
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen).print(lparen, out);
        AST parameters = lparen.getNextSibling();
        PrinterFactory.create(parameters).print(parameters, out);
        AST rparen = parameters.getNextSibling();
        PrinterFactory.create(rparen).print(rparen, out);
        JavaNode body = (JavaNode)rparen.getNextSibling();
        PrinterFactory.create(body).print(body, out);
    }

    private void printFinallyPart(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        this.logIssues(node, out);
        if (!this.isEolCommentBefore(node)) {
            out.print(out.getString(settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER, 1)), 153);
        }
        out.print("finally", 107);
        this.printCommentsAfter(node, out);
        JavaNode body = (JavaNode)node.getFirstChild();
        PrinterFactory.create(body).print(body, out);
    }
}

