/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ThrowsPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ThrowsPrinter();

    protected ThrowsPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        boolean indentCustom;
        AST firstType = node.getFirstChild();
        boolean wrappedBefore = false;
        boolean wrappedAfter = false;
        Marker marker = null;
        boolean wrapLines = settings.getBoolean(ConventionKeys.LINE_WRAP, true) && out.mode == 1;
        int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentDeep = settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        int indentLength = out.getIndentLength();
        int deepIndent = settings.getInt(ConventionKeys.INDENT_SIZE_DEEP, 55);
        int indentSize = settings.getInt(ConventionKeys.INDENT_SIZE_THROWS, -1);
        boolean bl = indentCustom = indentSize > -1;
        if (out.mode == 1 && (out.newline || settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_THROWS, false) || wrapLines && this.exceedsBarriers(node, firstType, lineLength, deepIndent, out))) {
            wrappedBefore = true;
            if (!out.newline) {
                out.printNewline();
            }
            if (indentCustom) {
                out.print(out.getString(indentSize), 153);
                out.print("throws ", 90);
                marker = out.state.markers.add();
            } else if (indentDeep && this.canAlign(firstType, lineLength, deepIndent, out)) {
                marker = out.state.markers.getLast();
                out.print(out.getString(marker.column - indentLength - 7), 153);
                out.print("throws ", 90);
            } else {
                indentDeep = false;
                out.indent();
                out.print("throws ", 90);
                marker = out.state.markers.add();
            }
        } else {
            out.print(" throws ", 90);
            marker = out.state.markers.add();
        }
        boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        boolean forceWrapping = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS, false);
        boolean wrapAll = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS_EXCEED, false) && out.mode == 1;
        TestNodeWriter tester = null;
        if (wrapLines || wrapAll) {
            tester = out.testers.get();
        }
        if (!forceWrapping && wrapAll) {
            PrinterFactory.create(node).print(node, tester);
            if (tester.length - 7 + out.column > lineLength) {
                forceWrapping = true;
            }
            tester.reset();
        }
        AST child = firstType;
        while (child != null) {
            switch (child.getType()) {
                case 82: {
                    AST next;
                    out.print(",", 82);
                    if (spaceAfterComma) {
                        out.print(" ", 153);
                    }
                    if (forceWrapping) {
                        out.printNewline();
                        if (!wrappedAfter) {
                            wrappedAfter = true;
                            if (!indentDeep) {
                                out.indent();
                            }
                        }
                        if (indentCustom && wrappedBefore) {
                            this.printIndentation(indentSize, out);
                            break;
                        }
                        this.printIndentation(out);
                        break;
                    }
                    if (!wrapLines || (next = child.getNextSibling()) == null) break;
                    PrinterFactory.create(next).print(next, tester);
                    if (tester.length + out.column > lineLength) {
                        out.printNewline();
                        if (!wrappedAfter) {
                            wrappedAfter = true;
                            if (!indentDeep) {
                                out.indent();
                            }
                        }
                        if (indentCustom && wrappedBefore) {
                            this.printIndentation(indentSize, out);
                        } else {
                            this.printIndentation(out);
                        }
                    }
                    tester.reset();
                    break;
                }
                default: {
                    PrinterFactory.create(child).print(child, out);
                }
            }
            child = child.getNextSibling();
        }
        if (tester != null) {
            out.testers.release(tester);
        }
        if (!indentDeep) {
            if (!indentCustom && wrappedBefore) {
                out.unindent();
            }
            if (wrappedAfter) {
                out.unindent();
            }
        }
        if (settings.getBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT_IF_WRAPPED, false) && (wrappedBefore || wrappedAfter || out.state.parametersWrapped)) {
            out.state.newlineBeforeLeftBrace = true;
        }
    }

    private boolean canAlign(AST node, int lineLength, int deepIndent, NodeWriter out) throws IOException {
        TestNodeWriter tester = out.testers.get();
        PrinterFactory.create(node).print(node, tester);
        Marker marker = out.state.markers.getLast();
        if (marker.column - 7 < deepIndent && marker.column + tester.length < lineLength && marker.column - out.getIndentLength() - 7 > 0) {
            out.testers.release(tester);
            return true;
        }
        out.testers.release(tester);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exceedsBarriers(AST node, AST firstType, int lineLength, int deepIndent, NodeWriter out) throws IOException {
        boolean bl;
        TestNodeWriter tester;
        block6: {
            boolean bl2;
            block5: {
                if (out.column + 1 > deepIndent) {
                    return true;
                }
                tester = out.testers.get();
                try {
                    PrinterFactory.create(node).print(node, tester);
                    if (out.column + tester.length > lineLength) {
                        boolean bl3 = true;
                        Object var9_10 = null;
                        out.testers.release(tester);
                        return bl3;
                    }
                    tester.reset();
                    PrinterFactory.create(firstType).print(firstType, tester);
                    if (out.column + 7 + tester.length > lineLength) {
                        bl2 = true;
                        break block5;
                    }
                    bl = false;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    out.testers.release(tester);
                    throw throwable;
                }
            }
            Object var9_11 = null;
            out.testers.release(tester);
            return bl2;
        }
        Object var9_12 = null;
        out.testers.release(tester);
        return bl;
    }
}

