/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.MethodCallPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.OperatorPrinter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.printer.WriterCache;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class DotPrinter
extends OperatorPrinter {
    private static final Printer INSTANCE = new DotPrinter();

    protected DotPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST rhs = this.printLeftHandSide(node, out);
        if (out.mode == 1) {
            boolean wrapLines = settings.getBoolean(ConventionKeys.LINE_WRAP, true);
            boolean forceWrappingForChainedCalls = settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_CHAINED_METHOD_CALL, false);
            if (wrapLines || forceWrappingForChainedCalls) {
                this.align(node, out);
            }
        }
        out.print(".", 69);
        this.printRightHandSide(rhs, out);
    }

    private int getLengthOfChainedCall(AST dot, JavaNode call, AST lastCall, WriterCache testers) throws IOException {
        AST elist;
        TestNodeWriter tester = testers.get();
        if (lastCall != call) {
            elist = dot.getNextSibling();
            PrinterFactory.create(elist).print(elist, tester);
        } else {
            elist = lastCall.getFirstChild().getNextSibling();
            PrinterFactory.create(elist).print(elist, tester);
        }
        AST child = dot.getFirstChild();
        switch (child.getType()) {
            case 31: {
                AST next = child.getNextSibling();
                PrinterFactory.create(next).print(next, tester);
                break;
            }
            default: {
                PrinterFactory.create(child).print(child, tester);
            }
        }
        int result = tester.length + 1;
        testers.release(tester);
        return result;
    }

    private void align(AST node, NodeWriter out) throws IOException {
        ParenthesesScope scope = (ParenthesesScope)out.state.parenScope.getFirst();
        boolean continuationIndent = settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_OPERATOR, false);
        if (scope.chainCall != null) {
            JavaNode parent = ((JavaNode)node).getParent();
            switch (parent.getType()) {
                case 31: {
                    int length;
                    boolean align = settings.getBoolean(ConventionKeys.ALIGN_METHOD_CALL_CHAINS, true);
                    if (parent == scope.chainCall) break;
                    if (settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_CHAINED_METHOD_CALL, false)) {
                        if (!MethodCallPrinter.isOuterMethodCall(parent)) break;
                        out.printNewline();
                        int indentLength = out.getIndentLength();
                        if (align) {
                            out.print(out.getString(scope.chainOffset > indentLength ? scope.chainOffset - indentLength : scope.chainOffset), 153);
                        } else if (continuationIndent) {
                            out.continuation = true;
                            this.printIndentation(out);
                        } else {
                            this.printIndentation(out);
                        }
                        return;
                    }
                    int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
                    if (out.column > lineLength) {
                        out.printNewline();
                        if (continuationIndent) {
                            out.continuation = true;
                        }
                        this.indent(align, scope, out);
                        return;
                    }
                    JavaNode first = MethodCallPrinter.getLastMethodCall(parent);
                    if (first == parent) {
                        AST c = node.getFirstChild().getNextSibling();
                        TestNodeWriter tester = out.testers.get();
                        PrinterFactory.create(c).print(c, tester);
                        if (out.column + tester.length < lineLength) {
                            out.testers.release(tester);
                            return;
                        }
                        out.testers.release(tester);
                    }
                    if (out.column + (length = this.getLengthOfChainedCall(node, parent, first, out.testers)) <= lineLength) break;
                    if (continuationIndent) {
                        out.continuation = true;
                    }
                    out.printNewline();
                    this.indent(align, scope, out);
                }
            }
        } else if (settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_OPERATOR, false)) {
            switch (((JavaNode)node).getParent().getType()) {
                case 69: {
                    break;
                }
                case 31: {
                    int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
                    if (out.column + 1 > lineLength) {
                        out.printNewline();
                        if (continuationIndent) {
                            out.continuation = true;
                        }
                        this.printIndentation(out);
                        break;
                    }
                    AST n = node.getFirstChild();
                    block7 : switch (n.getType()) {
                        case 84: {
                            AST child = n;
                            while (n != null) {
                                switch (n.getType()) {
                                    case 85: {
                                        n = n.getNextSibling();
                                        break block7;
                                    }
                                }
                                n = n.getNextSibling();
                            }
                            break;
                        }
                        default: {
                            n = n.getNextSibling();
                        }
                    }
                    TestNodeWriter tester = out.testers.get();
                    PrinterFactory.create(n).print(n, tester);
                    if (out.column + 1 + tester.length > lineLength) {
                        out.printNewline();
                        if (continuationIndent) {
                            out.continuation = true;
                        }
                        this.printIndentation(out);
                    }
                    out.testers.release(tester);
                }
            }
        }
    }

    private void indent(boolean align, ParenthesesScope scope, NodeWriter out) throws IOException {
        if (align) {
            int indentLength = out.getIndentLength();
            out.print(out.getString(scope.chainOffset > indentLength ? scope.chainOffset - indentLength : scope.chainOffset), 153);
        } else if (out.continuation || !out.continuation && settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_OPERATOR, false)) {
            this.printIndentation(out);
        } else {
            this.printIndentation(out);
        }
    }
}

