/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.ASTFactory;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeFactory;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Transformation;
import de.hunsicker.jalopy.language.TransformationException;
import de.hunsicker.jalopy.language.TreeWalker;
import java.util.ArrayList;
import java.util.List;

final class LoggerTransformation
extends TreeWalker
implements Transformation {
    private static final String DEBUG = "debug";
    private static final String LEVEL_DEBUG = "Level.DEBUG";
    private static final String LOCALIZED_LOG = "l7dlog";
    private static final String PRIORITY_DEBUG = "Priority.DEBUG";
    private static final ASTFactory AST_FACTORY = new JavaNodeFactory();
    private List _calls = new ArrayList(50);

    LoggerTransformation() {
    }

    public void apply(AST tree) throws TransformationException {
        try {
            this.walk(tree);
            int i = 0;
            int size = this._calls.size();
            while (i < size) {
                AST node = (AST)this._calls.get(i);
                AST name = node.getFirstChild();
                switch (name.getType()) {
                    case 69: {
                        JavaNode expr;
                        AST firstPart = name.getFirstChild();
                        AST lastPart = firstPart.getNextSibling();
                        String methodName = lastPart.getText();
                        if (!this.isDebugCall(node, methodName) || this.isEnclosed(expr = ((JavaNode)node).getParent())) break;
                        this.addConditional(expr, firstPart);
                    }
                }
                ++i;
            }
            Object var11_10 = null;
            this._calls.clear();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this._calls.clear();
            throw throwable;
        }
    }

    public void visit(AST node) {
        switch (node.getType()) {
            case 31: {
                this._calls.add(node);
            }
        }
    }

    private boolean isDebugCall(AST node, String name) {
        AST params;
        AST expr;
        if (DEBUG.equals(name)) {
            JavaNode n = (JavaNode)node;
            switch (n.getType()) {
                case 32: 
                case 89: {
                    return false;
                }
            }
            AST params2 = JavaNodeHelper.getFirstChild(node, 38);
            AST expr2 = params2.getFirstChild();
            return expr2 != null;
        }
        if (LOCALIZED_LOG.equals(name) && (expr = (params = JavaNodeHelper.getFirstChild(node, 38)).getFirstChild()) != null) {
            AST param = expr.getFirstChild();
            switch (param.getType()) {
                case 69: {
                    String n = JavaNodeHelper.getDottedName(param);
                    if (!LEVEL_DEBUG.equals(n) && !PRIORITY_DEBUG.equals(n)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isEnclosed(JavaNode expr) {
        JavaNode parent = expr.getParent();
        switch (parent.getType()) {
            case 92: {
                return true;
            }
            case 11: {
                return this.isEnclosed(parent);
            }
        }
        return false;
    }

    private void addConditional(JavaNode expr, AST name) {
        JavaNode cond = this.createConditional(name);
        JavaNode parent = expr.getParent();
        JavaNode prev = expr.getPreviousSibling();
        JavaNode next = (JavaNode)expr.getNextSibling();
        cond.setParent(parent);
        cond.setPreviousSibling(prev);
        if (parent == prev) {
            prev.setFirstChild(cond);
        } else {
            prev.setNextSibling(cond);
        }
        JavaNode lparen = (JavaNode)cond.getFirstChild().getNextSibling().getNextSibling();
        lparen.setNextSibling(expr);
        expr.setParent(cond);
        expr.setPreviousSibling(lparen);
        expr.setNextSibling(null);
        if (next != null) {
            cond.setNextSibling(next);
            next.setPreviousSibling(cond);
        }
    }

    private JavaNode createConditional(AST name) {
        AST qualifiedName = AST_FACTORY.create(69);
        qualifiedName.addChild(AST_FACTORY.dupTree(name));
        AST methodName = AST_FACTORY.create(68, "isDebugEnabled");
        qualifiedName.addChild(methodName);
        AST methodCall = AST_FACTORY.create(31);
        methodCall.addChild(qualifiedName);
        methodCall.addChild(AST_FACTORY.create(38));
        methodCall.addChild(AST_FACTORY.create(85));
        AST expr = AST_FACTORY.create(32);
        expr.addChild(methodCall);
        AST ifNode = AST_FACTORY.create(92);
        ifNode.addChild(AST_FACTORY.create(84));
        ifNode.addChild(expr);
        ifNode.addChild(AST_FACTORY.create(85));
        return (JavaNode)ifNode;
    }
}

