/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.antlr;

import de.hunsicker.antlr.CharScanner;

public class ANTLRHashString {
    private String s;
    private char[] buf;
    private int len;
    private CharScanner lexer;
    private static final int prime = 151;

    public ANTLRHashString(char[] buf, int length, CharScanner lexer) {
        this.lexer = lexer;
        this.setBuffer(buf, length);
    }

    public ANTLRHashString(CharScanner lexer) {
        this.lexer = lexer;
    }

    public ANTLRHashString(String s, CharScanner lexer) {
        this.lexer = lexer;
        this.setString(s);
    }

    private final char charAt(int index) {
        return this.s != null ? this.s.charAt(index) : this.buf[index];
    }

    public boolean equals(Object o) {
        if (!(o instanceof ANTLRHashString) && !(o instanceof String)) {
            return false;
        }
        ANTLRHashString s = o instanceof String ? new ANTLRHashString((String)o, this.lexer) : (ANTLRHashString)o;
        int l = this.length();
        if (s.length() != l) {
            return false;
        }
        if (this.lexer.getCaseSensitiveLiterals()) {
            int i = 0;
            while (i < l) {
                if (this.charAt(i) != s.charAt(i)) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < l) {
                if (this.lexer.toLower(this.charAt(i)) != this.lexer.toLower(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashval = 0;
        int l = this.length();
        if (this.lexer.getCaseSensitiveLiterals()) {
            int i = 0;
            while (i < l) {
                hashval = hashval * 151 + this.charAt(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < l) {
                hashval = hashval * 151 + this.lexer.toLower(this.charAt(i));
                ++i;
            }
        }
        return hashval;
    }

    private final int length() {
        return this.s != null ? this.s.length() : this.len;
    }

    public void setBuffer(char[] buf, int length) {
        this.buf = buf;
        this.len = length;
        this.s = null;
    }

    public void setString(String s) {
        this.s = s;
        this.buf = null;
    }
}

