package org.jboss.seam.example.pdf;

import java.awt.Image;

import org.jboss.seam.annotations.Name;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.PieDataset;


@Name("images")
public class Images {
    private PieDataset getData() {
        DefaultPieDataset data = new DefaultPieDataset();

        data.setValue("gen",   7);
        data.setValue("mail",  15);
        data.setValue("main",  387);
        data.setValue("pdf",   28);
        data.setValue("test",  22);
        data.setValue("ui",    54);
        return data;
    }

    public Image getChart() {
        JFreeChart chart = ChartFactory.createPieChart("Seam Classes by Module",
                                                       getData(),
                                                       true,
                                                       true,
                                                       false);

        return chart.createBufferedImage(400,300);
    }

}
